/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLocationChangeset;
import org.openstreetmap.josm.plugins.mapillary.utils.ValidationUtil;

public class MapillaryImage
extends MapillaryAbstractImage {
    private final String key;
    private String user;
    private final List<String> signs = new ArrayList<String>();
    private String location;

    public MapillaryImage(String key, LatLon latLon, double ca) {
        super(latLon, ca);
        ValidationUtil.throwExceptionForInvalidImgKey(key, true);
        this.key = key;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getKey() {
        return this.key;
    }

    public void addSign(String sign) {
        this.signs.add(sign);
    }

    public List<String> getSigns() {
        return this.signs;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        return String.format("Image[key=%s,lat=%f,lon=%f,ca=%f,location=%s,user=%s,capturedAt=%d]", this.key, this.latLon.lat(), this.latLon.lon(), this.ca, this.location, this.user, this.capturedAt);
    }

    public boolean equals(Object object) {
        return object instanceof MapillaryImage && this.key.equals(((MapillaryImage)object).getKey());
    }

    @Override
    public int compareTo(MapillaryAbstractImage image) {
        if (image instanceof MapillaryImage) {
            return this.key.compareTo(((MapillaryImage)image).getKey());
        }
        return super.compareTo(image);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public void stopMoving() {
        super.stopMoving();
        this.checkModified();
    }

    private void checkModified() {
        MapillaryLayer mapillaryLayer = MapillaryLayer.getInstance();
        MapillaryLocationChangeset locationChangeset = mapillaryLayer.getLocationChangeset();
        if (this.isModified()) {
            locationChangeset.add(this);
        } else {
            locationChangeset.remove(this);
        }
    }

    @Override
    public void turn(double ca) {
        super.turn(ca);
        this.checkModified();
    }
}

