/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.taginfos;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class TagInfoXpString
extends TagInfo {
    public TagInfoXpString(String name, int tag, int length, TiffDirectoryType directoryType) {
        super(name, tag, FieldType.BYTE, length, directoryType);
    }

    @Override
    public byte[] encodeValue(FieldType fieldType, Object value, ByteOrder byteOrder) throws ImageWriteException {
        if (!(value instanceof String)) {
            throw new ImageWriteException("Text value not String", value);
        }
        String s = (String)value;
        try {
            return s.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException cannotHappen) {
            return null;
        }
    }

    @Override
    public String getValue(TiffField entry) throws ImageReadException {
        if (entry.getFieldType() != FieldType.BYTE) {
            throw new ImageReadException("Text field not encoded as bytes.");
        }
        try {
            return new String(entry.getByteArrayValue(), "UTF-16LE");
        }
        catch (UnsupportedEncodingException cannotHappen) {
            return null;
        }
    }
}

