/*
 * Decompiled with CFR 0.152.
 */
package CommandLine;

import CommandLine.CommandLine;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.ImageProvider;

public class AnyAction
extends MapMode
implements AWTEventListener {
    private final CommandLine parentPlugin;
    private final Cursor cursorNormal;
    private final Cursor cursorActive;
    private Cursor currentCursor;
    private Point mousePos;
    private OsmPrimitive nearestPrimitive;
    private boolean isCtrlDown;

    public AnyAction(MapFrame mapFrame, CommandLine parentPlugin) {
        super(null, "addsegment.png", null, mapFrame, ImageProvider.getCursor((String)"normal", (String)"selection"));
        this.parentPlugin = parentPlugin;
        this.cursorNormal = ImageProvider.getCursor((String)"normal", (String)"selection");
        this.cursorActive = ImageProvider.getCursor((String)"normal", (String)"joinnode");
        this.currentCursor = this.cursorNormal;
        this.nearestPrimitive = null;
    }

    public void enterMode() {
        super.enterMode();
        this.currentCursor = this.cursorNormal;
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            Main.warn((Throwable)ex);
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            Main.warn((Throwable)ex);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.processMouseEvent(e);
        this.updCursor();
        Main.map.mapView.repaint();
        super.mouseMoved(e);
    }

    public void mousePressed(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.processMouseEvent(e);
        if (this.nearestPrimitive != null) {
            DataSet ds = Main.getLayerManager().getEditDataSet();
            if (this.isCtrlDown) {
                ds.clearSelection(new PrimitiveId[]{this.nearestPrimitive});
                Main.map.mapView.repaint();
            } else {
                int maxInstances = this.parentPlugin.currentCommand.parameters.get((int)this.parentPlugin.currentCommand.currentParameterNum).maxInstances;
                switch (maxInstances) {
                    case 0: {
                        ds.addSelected(new PrimitiveId[]{this.nearestPrimitive});
                        Main.map.mapView.repaint();
                        break;
                    }
                    case 1: {
                        ds.addSelected(new PrimitiveId[]{this.nearestPrimitive});
                        Main.map.mapView.repaint();
                        this.parentPlugin.loadParameter(this.nearestPrimitive, true);
                        this.exitMode();
                        break;
                    }
                    default: {
                        if (ds.getSelected().size() < maxInstances) {
                            ds.addSelected(new PrimitiveId[]{this.nearestPrimitive});
                            Main.map.mapView.repaint();
                            break;
                        }
                        Main.info((String)"Maximum instances!");
                    }
                }
            }
        }
        super.mousePressed(e);
    }

    @Override
    public void eventDispatched(AWTEvent arg0) {
        if (!(arg0 instanceof KeyEvent)) {
            return;
        }
        KeyEvent ev = (KeyEvent)arg0;
        boolean bl = this.isCtrlDown = (ev.getModifiersEx() & 0x80) != 0;
        if (ev.getKeyCode() == 27 && ev.getID() == 401) {
            ev.consume();
            this.cancelDrawing();
        }
    }

    private void updCursor() {
        if (this.mousePos != null) {
            if (!Main.isDisplayingMapView()) {
                return;
            }
            this.nearestPrimitive = Main.map.mapView.getNearestNodeOrWay(this.mousePos, AbstractPrimitive::isUsable, false);
            if (this.nearestPrimitive != null) {
                this.setCursor(this.cursorActive);
            } else {
                this.setCursor(this.cursorNormal);
            }
        }
    }

    private void processMouseEvent(MouseEvent e) {
        if (e != null) {
            this.mousePos = e.getPoint();
        }
    }

    private void setCursor(final Cursor c) {
        if (this.currentCursor.equals(c)) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!(Main.map.mapMode instanceof AnyAction)) {
                        return;
                    }
                    Main.map.mapView.setCursor(c);
                }
            });
            this.currentCursor = c;
        }
        catch (Exception e) {
            Main.warn((Throwable)e);
        }
    }

    public void cancelDrawing() {
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        Main.map.statusLine.setHeading(-1.0);
        Main.map.statusLine.setAngle(-1.0);
        Main.map.mapView.repaint();
        this.updateStatusLine();
        this.parentPlugin.abortInput();
    }
}

