/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.io.download;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillarySquareDownloadManagerThread;
import org.openstreetmap.josm.tools.I18n;

public final class MapillaryDownloader {
    private static List<Thread> threads = new ArrayList<Thread>();
    public static final double MAX_AREA = Main.pref.getDouble("mapillary.max-download-area", 0.015);
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(3, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));

    private MapillaryDownloader() {
    }

    public static void getImages(LatLon minLatLon, LatLon maxLatLon) {
        if (minLatLon == null || maxLatLon == null) {
            throw new IllegalArgumentException();
        }
        MapillaryDownloader.getImages(new Bounds(minLatLon, maxLatLon));
    }

    public static void getImages(Bounds bounds) {
        MapillaryDownloader.run(new MapillarySquareDownloadManagerThread(bounds));
    }

    public static DOWNLOAD_MODE getMode() {
        return MapillaryLayer.hasInstance() && MapillaryLayer.getInstance().tempSemiautomatic ? DOWNLOAD_MODE.VISIBLE_AREA : DOWNLOAD_MODE.fromPrefId(Main.pref.get("mapillary.download-mode"));
    }

    private static void run(Thread t) {
        threads.add(t);
        executor.execute(t);
    }

    public static void completeView() {
        if (MapillaryDownloader.getMode() != DOWNLOAD_MODE.VISIBLE_AREA && MapillaryDownloader.getMode() != DOWNLOAD_MODE.MANUAL_ONLY) {
            throw new IllegalStateException("Download mode must be 'visible area' or 'manual only'");
        }
        Bounds view = Main.map.mapView.getRealBounds();
        if (view.getArea() > MAX_AREA) {
            return;
        }
        if (MapillaryDownloader.isViewDownloaded(view)) {
            return;
        }
        MapillaryLayer.getInstance().getData().getBounds().add(view);
        MapillaryDownloader.getImages(view);
    }

    private static boolean isViewDownloaded(Bounds view) {
        int j;
        int i;
        int n = 15;
        boolean[][] inside = new boolean[n][n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                if (!MapillaryDownloader.isInBounds(new LatLon(view.getMinLat() + (view.getMaxLat() - view.getMinLat()) * ((double)i / (double)n), view.getMinLon() + (view.getMaxLon() - view.getMinLon()) * ((double)j / (double)n)))) continue;
                inside[i][j] = true;
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                if (inside[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInBounds(LatLon latlon) {
        for (Bounds bounds : MapillaryLayer.getInstance().getData().getBounds()) {
            if (!bounds.contains(latlon)) continue;
            return true;
        }
        return false;
    }

    public static void automaticDownload() {
        if (Main.getLayerManager().getEditLayer() == null) {
            return;
        }
        if (MapillaryDownloader.isAreaTooBig()) {
            MapillaryDownloader.tooBigErrorDialog();
            return;
        }
        if (MapillaryDownloader.getMode() != DOWNLOAD_MODE.OSM_AREA) {
            throw new IllegalStateException("Must be in automatic mode.");
        }
        for (Bounds bounds : Main.getLayerManager().getEditLayer().data.getDataSourceBounds()) {
            if (MapillaryLayer.getInstance().getData().getBounds().contains(bounds)) continue;
            MapillaryLayer.getInstance().getData().getBounds().add(bounds);
            MapillaryDownloader.getImages(bounds.getMin(), bounds.getMax());
        }
    }

    private static boolean isAreaTooBig() {
        double area = 0.0;
        for (Bounds bounds : Main.getLayerManager().getEditLayer().data.getDataSourceBounds()) {
            area += bounds.getArea();
        }
        return area > MAX_AREA;
    }

    private static void tooBigErrorDialog() {
        if (SwingUtilities.isEventDispatchThread()) {
            MapillaryLayer.getInstance().tempSemiautomatic = true;
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getDownloadViewMenu(), true);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The downloaded OSM area is too big. Download mode has been changed to semiautomatic until the layer is restarted.", (Object[])new Object[0]));
        } else {
            SwingUtilities.invokeLater(() -> MapillaryDownloader.tooBigErrorDialog());
        }
    }

    public static void stopAll() {
        for (Thread t : threads) {
            if (t.isAlive()) {
                Main.info((String)(t + " is still alive!"));
            }
            t.interrupt();
        }
        threads.clear();
        executor.shutdownNow();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Main.error((Throwable)e);
        }
        executor = new ThreadPoolExecutor(3, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
    }

    public static enum DOWNLOAD_MODE {
        VISIBLE_AREA("visibleArea", I18n.tr((String)"everything in the visible area", (Object[])new Object[0])),
        OSM_AREA("osmArea", I18n.tr((String)"areas with downloaded OSM-data", (Object[])new Object[0])),
        MANUAL_ONLY("manualOnly", I18n.tr((String)"only when manually requested", (Object[])new Object[0]));

        private String prefId;
        private String label;

        private DOWNLOAD_MODE(String prefId, String label) {
            this.prefId = prefId;
            this.label = label;
        }

        public String getPrefId() {
            return this.prefId;
        }

        public String getLabel() {
            return this.label;
        }

        public static DOWNLOAD_MODE fromPrefId(String prefId) {
            if (MANUAL_ONLY.getPrefId().equals(prefId) || "Manual".equals(prefId)) {
                return MANUAL_ONLY;
            }
            if (OSM_AREA.getPrefId().equals(prefId) || "Automatic".equals(prefId)) {
                return OSM_AREA;
            }
            if (VISIBLE_AREA.getPrefId().equals(prefId) || "Semiautomatic".equals(prefId)) {
                return VISIBLE_AREA;
            }
            return DOWNLOAD_MODE.getDefault();
        }

        public static DOWNLOAD_MODE fromLabel(String label) {
            if (MANUAL_ONLY.getLabel().equals(label)) {
                return MANUAL_ONLY;
            }
            if (OSM_AREA.getLabel().equals(label)) {
                return OSM_AREA;
            }
            if (VISIBLE_AREA.getLabel().equals(label)) {
                return VISIBLE_AREA;
            }
            return DOWNLOAD_MODE.getDefault();
        }

        public static DOWNLOAD_MODE getDefault() {
            return OSM_AREA;
        }
    }
}

