/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLocationChangeset;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryURL;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.plugins.mapillary.utils.PluginState;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillarySubmitCurrentChangesetAction
extends JosmAction {
    private static final long serialVersionUID = 4995924098228082806L;
    private static final Log logger = LogFactory.getLog(MapillarySubmitCurrentChangesetAction.class);

    public MapillarySubmitCurrentChangesetAction() {
        super(I18n.tr((String)"Submit changeset", (Object[])new Object[0]), MapillaryPlugin.getProvider("icon24.png"), I18n.tr((String)"Submit the current changeset", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Submit changeset to Mapillary", (String)I18n.tr((String)"Submit the current changeset to Mapillary", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillarySubmitChangeset", false);
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent event) {
        String token = Main.pref.get("mapillary.access-token");
        if (token == null || token.trim().isEmpty()) {
            PluginState.notLoggedInToMapillaryDialog();
            return;
        }
        PluginState.setSubmittingChangeset(true);
        MapillaryUtils.updateHelpText();
        HttpClientBuilder builder = HttpClientBuilder.create();
        HttpPost httpPost = new HttpPost(MapillaryURL.submitChangesetURL().toString());
        httpPost.addHeader("content-type", "application/json");
        httpPost.addHeader("Authorization", "Bearer " + token);
        JsonArrayBuilder changes = Json.createArrayBuilder();
        MapillaryLocationChangeset locationChangeset = MapillaryLayer.getInstance().getLocationChangeset();
        for (MapillaryImage image : locationChangeset) {
            changes.add(Json.createObjectBuilder().add("image_key", image.getKey()).add("values", Json.createObjectBuilder().add("from", Json.createObjectBuilder().add("ca", image.getCa()).add("lat", image.getLatLon().getY()).add("lon", image.getLatLon().getX())).add("to", Json.createObjectBuilder().add("ca", image.getTempCa()).add("lat", image.getTempLatLon().getY()).add("lon", image.getTempLatLon().getX()))));
        }
        String json = Json.createObjectBuilder().add("change_type", "location").add("changes", changes).add("request_comment", "JOSM-created").build().toString();
        try (CloseableHttpClient httpClient = builder.build();){
            httpPost.setEntity((HttpEntity)new StringEntity(json));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) return;
            String key = Json.createReader((InputStream)response.getEntity().getContent()).readObject().getString("key");
            Class<MapillaryUtils> clazz = MapillaryUtils.class;
            synchronized (MapillaryUtils.class) {
                Main.map.statusLine.setHelpText(String.format("%s images submitted, Changeset key: %s", locationChangeset.size(), key));
                // ** MonitorExit[var12_16] (shouldn't be in output)
                locationChangeset.cleanChangeset();
                return;
            }
        }
        catch (IOException e) {
            logger.error((Object)"got exception", (Throwable)e);
            Class<MapillaryUtils> clazz = MapillaryUtils.class;
            synchronized (MapillaryUtils.class) {
                Main.map.statusLine.setHelpText("Error submitting Mapillary changeset: " + e.getMessage());
                // ** MonitorExit[var9_11] (shouldn't be in output)
                return;
            }
        }
        finally {
            PluginState.setSubmittingChangeset(false);
        }
    }
}

