/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryDownloadAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryDownloadViewAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryExportAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryImportAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryImportIntoSequenceAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryJoinAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryUploadAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryWalkAction;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillaryZoomAction;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryChangesetDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryFilterDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryHistoryDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryPreferenceSetting;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillaryDownloader;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryUser;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapillaryPlugin
extends Plugin {
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final ImageIcon ICON24 = new ImageProvider("icon24.png").get();
    public static final ImageIcon ICON16 = new ImageProvider("icon16.png").get();
    public static final ImageIcon ICON12 = new ImageIcon(ICON24.getImage().getScaledInstance(12, 12, 4));
    public static final ImageIcon MAP_ICON = new ImageProvider("mapicon.png").get();
    public static final ImageIcon MAP_ICON_SELECTED = new ImageProvider("mapiconselected.png").get();
    public static final ImageIcon MAP_ICON_IMPORTED = new ImageProvider("mapiconimported.png").get();
    public static final ImageIcon MAP_SIGN = new ImageProvider("sign.png").get();
    public static CacheAccess<String, BufferedImageCacheEntry> cache;
    private static final MapillaryDownloadAction downloadAction;
    private static final MapillaryExportAction exportAction;
    private static final MapillaryImportAction importAction;
    private static final MapillaryZoomAction zoomAction;
    private static final MapillaryDownloadViewAction downloadViewAction;
    private static final MapillaryImportIntoSequenceAction importIntoSequenceAction;
    private static final MapillaryJoinAction joinAction;
    private static final MapillaryWalkAction walkAction;
    private static final MapillaryUploadAction uploadAction;
    private static final JMenuItem downloadMenu;
    private static final JMenuItem exportMenu;
    private static final JMenuItem importMenu;
    private static final JMenuItem zoomMenu;
    private static final JMenuItem downloadViewMenu;
    private static final JMenuItem importIntoSequenceMenu;
    private static final JMenuItem joinMenu;
    private static final JMenuItem walkMenu;
    private static final JMenuItem uploadMenu;

    public MapillaryPlugin(PluginInformation info) {
        super(info);
        try {
            cache = JCSCacheManager.getCache((String)"mapillary", (int)10, (int)10000, (String)(this.getPluginDir() + "/cache/"));
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
        if (Main.pref.get("mapillary.access-token") == null) {
            MapillaryUser.setTokenValid(false);
        }
        Main.pref.put("mapillary.download-mode", MapillaryDownloader.DOWNLOAD_MODE.fromPrefId(Main.pref.get("mapillary.download-mode")).getPrefId());
    }

    public static JMenuItem getDownloadViewMenu() {
        return downloadViewMenu;
    }

    public static JMenuItem getExportMenu() {
        return exportMenu;
    }

    public static JMenuItem getJoinMenu() {
        return joinMenu;
    }

    public static MapillaryDataListener getUploadAction() {
        return uploadAction;
    }

    public static JMenuItem getUploadMenu() {
        return uploadMenu;
    }

    public static MapillaryWalkAction getWalkAction() {
        return walkAction;
    }

    public static JMenuItem getWalkMenu() {
        return walkMenu;
    }

    public static MapillaryDataListener getZoomAction() {
        return zoomAction;
    }

    public static JMenuItem getZoomMenu() {
        return zoomMenu;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            Main.map.addToggleDialog((ToggleDialog)MapillaryMainDialog.getInstance(), false);
            Main.map.addToggleDialog((ToggleDialog)MapillaryHistoryDialog.getInstance(), false);
            Main.map.addToggleDialog((ToggleDialog)MapillaryChangesetDialog.getInstance(), false);
            Main.map.addToggleDialog((ToggleDialog)MapillaryFilterDialog.getInstance(), false);
            MapillaryPlugin.setMenuEnabled(downloadMenu, true);
            if (MapillaryDownloader.getMode() == MapillaryDownloader.DOWNLOAD_MODE.MANUAL_ONLY) {
                MapillaryPlugin.setMenuEnabled(downloadViewMenu, true);
            }
            MapillaryPlugin.setMenuEnabled(importMenu, true);
            MapillaryPlugin.setMenuEnabled(importIntoSequenceMenu, true);
        }
        if (oldFrame != null && newFrame == null) {
            MapillaryMainDialog.destroyInstance();
            MapillaryHistoryDialog.destroyInstance();
            MapillaryChangesetDialog.destroyInstance();
            MapillaryFilterDialog.destroyInstance();
            MapillaryPlugin.setMenuEnabled(downloadMenu, false);
            MapillaryPlugin.setMenuEnabled(downloadViewMenu, false);
            MapillaryPlugin.setMenuEnabled(importMenu, false);
            MapillaryPlugin.setMenuEnabled(importIntoSequenceMenu, false);
        }
    }

    public static void setMenuEnabled(JMenuItem menu, boolean value) {
        if (menu == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> MapillaryPlugin.setMenuEnabled(menu, value));
        } else {
            menu.setEnabled(value);
            menu.getAction().setEnabled(value);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new MapillaryPreferenceSetting();
    }

    public static ImageProvider getProvider(String s) {
        if (Main.main == null) {
            return null;
        }
        return new ImageProvider(s);
    }

    static {
        downloadAction = new MapillaryDownloadAction();
        exportAction = new MapillaryExportAction();
        importAction = new MapillaryImportAction();
        zoomAction = new MapillaryZoomAction();
        downloadViewAction = new MapillaryDownloadViewAction();
        importIntoSequenceAction = new MapillaryImportIntoSequenceAction();
        joinAction = new MapillaryJoinAction();
        walkAction = new MapillaryWalkAction();
        uploadAction = new MapillaryUploadAction();
        if (Main.main == null) {
            exportMenu = null;
            downloadMenu = null;
            importMenu = null;
            zoomMenu = null;
            downloadViewMenu = null;
            importIntoSequenceMenu = null;
            joinMenu = null;
            walkMenu = null;
            uploadMenu = null;
        } else {
            exportMenu = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)exportAction, (boolean)false, (Integer)14);
            exportMenu.setEnabled(false);
            downloadMenu = MainMenu.add((JMenu)Main.main.menu.imageryMenu, (JosmAction)downloadAction, (boolean)false);
            downloadMenu.setEnabled(false);
            importMenu = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)importAction, (boolean)false, (Integer)14);
            importMenu.setEnabled(false);
            zoomMenu = MainMenu.add((JMenu)Main.main.menu.viewMenu, (JosmAction)zoomAction, (boolean)false, (Integer)15);
            zoomMenu.setEnabled(false);
            downloadViewMenu = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)downloadViewAction, (boolean)false, (Integer)14);
            downloadViewMenu.setEnabled(false);
            importIntoSequenceMenu = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)importIntoSequenceAction, (boolean)false, (Integer)14);
            importIntoSequenceMenu.setEnabled(false);
            joinMenu = MainMenu.add((JMenu)Main.main.menu.dataMenu, (JosmAction)joinAction, (boolean)false);
            joinMenu.setEnabled(false);
            walkMenu = MainMenu.add((JMenu)Main.main.menu.moreToolsMenu, (JosmAction)walkAction, (boolean)false);
            walkMenu.setEnabled(false);
            uploadMenu = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)uploadAction, (boolean)false, (Integer)14);
            uploadMenu.setEnabled(false);
        }
    }
}

