/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;
import org.mapdb.Utils;

public class SerializerPojo
extends SerializerBase {
    protected static final Serializer<CopyOnWriteArrayList<ClassInfo>> serializer = new Serializer<CopyOnWriteArrayList<ClassInfo>>(){

        @Override
        public void serialize(DataOutput out, CopyOnWriteArrayList<ClassInfo> obj) throws IOException {
            Utils.packInt(out, obj.size());
            for (ClassInfo ci : obj) {
                out.writeUTF(ci.getName());
                out.writeBoolean(ci.isEnum);
                out.writeBoolean(ci.isExternalizable);
                if (ci.isExternalizable) continue;
                Utils.packInt(out, ci.fields.size());
                for (FieldInfo fi : ci.fields) {
                    out.writeUTF(fi.getName());
                    out.writeBoolean(fi.isPrimitive());
                    out.writeUTF(fi.getType());
                }
            }
        }

        @Override
        public CopyOnWriteArrayList<ClassInfo> deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return new CopyOnWriteArrayList<ClassInfo>();
            }
            int size = Utils.unpackInt(in);
            ArrayList<ClassInfo> ret = new ArrayList<ClassInfo>(size);
            for (int i = 0; i < size; ++i) {
                String className = in.readUTF();
                boolean isEnum = in.readBoolean();
                boolean isExternalizable = in.readBoolean();
                int fieldsNum = isExternalizable ? 0 : Utils.unpackInt(in);
                FieldInfo[] fields = new FieldInfo[fieldsNum];
                for (int j = 0; j < fieldsNum; ++j) {
                    fields[j] = new FieldInfo(in.readUTF(), in.readBoolean(), in.readUTF(), SerializerPojo.classForName(className));
                }
                ret.add(new ClassInfo(className, fields, isEnum, isExternalizable));
            }
            return new CopyOnWriteArrayList<ClassInfo>(ret);
        }
    };
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    CopyOnWriteArrayList<ClassInfo> registered;
    Map<Class<?>, Integer> class2classId = new HashMap();
    Map<Integer, Class<?>> classId2class = new HashMap();
    private static Method sunConstructor = null;
    private static Object sunReflFac = null;
    private static Method androidConstructor = null;
    private static Map<Class<?>, Constructor<?>> class2constuctor;

    private static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public SerializerPojo(CopyOnWriteArrayList<ClassInfo> registered) {
        this.registered = registered == null ? new CopyOnWriteArrayList() : registered;
    }

    public void registerClass(Class<?> clazz) throws IOException {
        if (clazz != Object.class) {
            this.assertClassSerializable(clazz);
        }
        if (this.containsClass(clazz)) {
            return;
        }
        ObjectStreamField[] streamFields = this.getFields(clazz);
        FieldInfo[] fields = new FieldInfo[streamFields.length];
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField sf = streamFields[i];
            fields[i] = new FieldInfo(sf, clazz);
        }
        ClassInfo i = new ClassInfo(clazz.getName(), fields, clazz.isEnum(), Externalizable.class.isAssignableFrom(clazz));
        this.class2classId.put(clazz, this.registered.size());
        this.classId2class.put(this.registered.size(), clazz);
        this.registered.add(i);
        this.saveClassInfo();
    }

    protected void saveClassInfo() {
    }

    private ObjectStreamField[] getFields(Class<?> clazz) {
        ObjectStreamField[] fields = null;
        ClassInfo classInfo = null;
        Integer classId = this.class2classId.get(clazz);
        if (classId != null) {
            classInfo = this.registered.get(classId);
            fields = classInfo.getObjectStreamFields();
        }
        if (fields == null) {
            ObjectStreamClass streamClass = ObjectStreamClass.lookup(clazz);
            SerializerBase.FastArrayList<ObjectStreamField> fieldsList = new SerializerBase.FastArrayList<ObjectStreamField>();
            while (streamClass != null) {
                for (ObjectStreamField f : streamClass.getFields()) {
                    fieldsList.add(f);
                }
                clazz = clazz.getSuperclass();
                streamClass = ObjectStreamClass.lookup(clazz);
            }
            fields = new ObjectStreamField[fieldsList.size()];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = (ObjectStreamField)fieldsList.get(i);
            }
            if (classInfo != null) {
                classInfo.setObjectStreamFields(fields);
            }
        }
        return fields;
    }

    private void assertClassSerializable(Class<?> clazz) throws NotSerializableException, InvalidClassException {
        if (this.containsClass(clazz)) {
            return;
        }
        if (!Serializable.class.isAssignableFrom(clazz)) {
            throw new NotSerializableException(clazz.getName());
        }
    }

    public Object getFieldValue(String fieldName, Object object) {
        try {
            this.registerClass(object.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClassInfo classInfo = this.registered.get(this.class2classId.get(object.getClass()));
        return this.getFieldValue(classInfo.getField(fieldName), object);
    }

    public Object getFieldValue(FieldInfo fieldInfo, Object object) {
        Object fieldAccessor = fieldInfo.getter;
        try {
            if (fieldAccessor instanceof Method) {
                Method m = (Method)fieldAccessor;
                return m.invoke(object, new Object[0]);
            }
            Field f = (Field)fieldAccessor;
            return f.get(object);
        }
        catch (Exception exception) {
            throw new NoSuchFieldError(object.getClass() + "." + fieldInfo.getName());
        }
    }

    public void setFieldValue(String fieldName, Object object, Object value) {
        try {
            this.registerClass(object.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClassInfo classInfo = this.registered.get(this.class2classId.get(object.getClass()));
        this.setFieldValue(classInfo.getField(fieldName), object, value);
    }

    public void setFieldValue(FieldInfo fieldInfo, Object object, Object value) {
        Object fieldAccessor = fieldInfo.setter;
        try {
            if (fieldAccessor instanceof Method) {
                Method m = (Method)fieldAccessor;
                m.invoke(object, value);
            } else {
                Field f = (Field)fieldAccessor;
                f.set(object, value);
            }
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new NoSuchFieldError(object.getClass() + "." + fieldInfo.getName());
        }
    }

    public boolean containsClass(Class<?> clazz) {
        return this.class2classId.get(clazz) != null;
    }

    public int getClassId(Class<?> clazz) {
        Integer classId = this.class2classId.get(clazz);
        if (classId != null) {
            return classId;
        }
        throw new Error("Class is not registered: " + clazz);
    }

    @Override
    protected void serializeUnknownObject(DataOutput out, Object obj, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
        out.write(1);
        this.registerClass(obj.getClass());
        int classId = this.getClassId(obj.getClass());
        Utils.packInt(out, classId);
        ClassInfo classInfo = this.registered.get(classId);
        if (classInfo.isExternalizable) {
            throw new InternalError("Can not serialize Externalizable class");
        }
        if (classInfo.isEnum) {
            int ordinal = ((Enum)obj).ordinal();
            Utils.packInt(out, ordinal);
        }
        ObjectStreamField[] fields = this.getFields(obj.getClass());
        Utils.packInt(out, fields.length);
        for (ObjectStreamField f : fields) {
            int fieldId = classInfo.getFieldId(f.getName());
            if (fieldId == -1) {
                fieldId = classInfo.addFieldInfo(new FieldInfo(f, obj.getClass()));
                this.saveClassInfo();
            }
            Utils.packInt(out, fieldId);
            Object fieldValue = this.getFieldValue(classInfo.getField(fieldId), obj);
            this.serialize(out, fieldValue, objectStack);
        }
    }

    @Override
    protected Object deserializeUnknownHeader(DataInput in, int head, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
        if (head != 1) {
            throw new InternalError();
        }
        try {
            Object o;
            int classId = Utils.unpackInt(in);
            ClassInfo classInfo = this.registered.get(classId);
            Class<?> clazz = this.classId2class.get(classId);
            if (clazz == null) {
                clazz = Class.forName(classInfo.getName());
            }
            this.assertClassSerializable(clazz);
            if (classInfo.isEnum) {
                int ordinal = Utils.unpackInt(in);
                o = clazz.getEnumConstants()[ordinal];
            } else {
                o = this.createInstanceSkippinkConstructor(clazz);
            }
            objectStack.add(o);
            if (classInfo.isExternalizable) {
                throw new InternalError("can not serialize Externalizable class");
            }
            int fieldCount = Utils.unpackInt(in);
            for (int i = 0; i < fieldCount; ++i) {
                int fieldId = Utils.unpackInt(in);
                FieldInfo f = classInfo.getField(fieldId);
                Object fieldValue = this.deserialize(in, objectStack);
                this.setFieldValue(f, o, fieldValue);
            }
            return o;
        }
        catch (Exception e) {
            throw new Error("Could not instanciate class", e);
        }
    }

    protected <T> T createInstanceSkippinkConstructor(Class<T> clazz) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        if (sunConstructor != null) {
            Constructor intConstr = class2constuctor.get(clazz);
            if (intConstr == null) {
                Constructor objDef = Object.class.getDeclaredConstructor(new Class[0]);
                intConstr = (Constructor)sunConstructor.invoke(sunReflFac, clazz, objDef);
                class2constuctor.put(clazz, intConstr);
            }
            return (T)intConstr.newInstance(new Object[0]);
        }
        if (androidConstructor != null) {
            return (T)androidConstructor.invoke(null, clazz, Object.class);
        }
        Constructor<Object> c = class2constuctor.get(clazz);
        if (c == null) {
            c = clazz.getConstructor(new Class[0]);
            if (!c.isAccessible()) {
                c.setAccessible(true);
            }
            class2constuctor.put(clazz, c);
        }
        return (T)c.newInstance(new Object[0]);
    }

    static {
        try {
            Class<?> clazz = Class.forName("sun.reflect.ReflectionFactory");
            if (clazz != null) {
                Method getReflectionFactory = clazz.getMethod("getReflectionFactory", new Class[0]);
                sunReflFac = getReflectionFactory.invoke(null, new Object[0]);
                sunConstructor = clazz.getMethod("newConstructorForSerialization", Class.class, Constructor.class);
            }
        }
        catch (Exception clazz) {
            // empty catch block
        }
        if (sunConstructor == null) {
            try {
                Method newInstance = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
                newInstance.setAccessible(true);
                androidConstructor = newInstance;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        class2constuctor = new ConcurrentHashMap();
    }

    static class FieldInfo {
        private final String name;
        private final boolean primitive;
        private final String type;
        private Class<?> typeClass;
        private final Class<?> clazz;
        private Object setter;
        private Object getter;

        public FieldInfo(String name, boolean primitive, String type, Class<?> clazz) {
            this.name = name;
            this.primitive = primitive;
            this.type = type;
            this.clazz = clazz;
            try {
                this.typeClass = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                this.typeClass = null;
            }
            this.initSetter();
            this.initGetter();
        }

        private void initSetter() {
            String setterName = "set" + this.firstCharCap(this.name);
            for (Class<?> aClazz = this.clazz; aClazz != Object.class; aClazz = aClazz.getSuperclass()) {
                try {
                    Method m = aClazz.getMethod(setterName, this.typeClass);
                    if (m != null) {
                        this.setter = m;
                        return;
                    }
                }
                catch (Exception m) {
                    // empty catch block
                }
                try {
                    Field f = aClazz.getDeclaredField(this.name);
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    this.setter = f;
                    return;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }

        private void initGetter() {
            String getterName = "get" + this.firstCharCap(this.name);
            for (Class<?> aClazz = this.clazz; aClazz != Object.class; aClazz = aClazz.getSuperclass()) {
                try {
                    Method m = aClazz.getMethod(getterName, new Class[0]);
                    if (m != null) {
                        this.getter = m;
                        return;
                    }
                }
                catch (Exception m) {
                    // empty catch block
                }
                try {
                    Field f = aClazz.getDeclaredField(this.name);
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    this.getter = f;
                    return;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }

        public FieldInfo(ObjectStreamField sf, Class<?> clazz) {
            this(sf.getName(), sf.isPrimitive(), sf.getType().getName(), clazz);
        }

        public String getName() {
            return this.name;
        }

        public boolean isPrimitive() {
            return this.primitive;
        }

        public String getType() {
            return this.type;
        }

        private String firstCharCap(String s) {
            return Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
    }

    protected static class ClassInfo {
        private final String name;
        private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
        private final Map<String, FieldInfo> name2fieldInfo = new HashMap<String, FieldInfo>();
        private final Map<String, Integer> name2fieldId = new HashMap<String, Integer>();
        private ObjectStreamField[] objectStreamFields;
        final boolean isEnum;
        final boolean isExternalizable;

        ClassInfo(String name, FieldInfo[] fields, boolean isEnum, boolean isExternalizable) {
            this.name = name;
            this.isEnum = isEnum;
            this.isExternalizable = isExternalizable;
            for (FieldInfo f : fields) {
                this.name2fieldId.put(f.getName(), this.fields.size());
                this.fields.add(f);
                this.name2fieldInfo.put(f.getName(), f);
            }
        }

        public String getName() {
            return this.name;
        }

        public FieldInfo[] getFields() {
            return this.fields.toArray(new FieldInfo[this.fields.size()]);
        }

        public FieldInfo getField(String name) {
            return this.name2fieldInfo.get(name);
        }

        public int getFieldId(String name) {
            Integer fieldId = this.name2fieldId.get(name);
            if (fieldId != null) {
                return fieldId;
            }
            return -1;
        }

        public FieldInfo getField(int serialId) {
            return this.fields.get(serialId);
        }

        public int addFieldInfo(FieldInfo field) {
            this.name2fieldId.put(field.getName(), this.fields.size());
            this.name2fieldInfo.put(field.getName(), field);
            this.fields.add(field);
            return this.fields.size() - 1;
        }

        public ObjectStreamField[] getObjectStreamFields() {
            return this.objectStreamFields;
        }

        public void setObjectStreamFields(ObjectStreamField[] objectStreamFields) {
            this.objectStreamFields = objectStreamFields;
        }
    }
}

