/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;

public class MapBasedTagGroup
implements TagGroup {
    private final Map<String, String> tagMap;

    public MapBasedTagGroup(Map<String, String> tagMap) {
        if (tagMap == null) {
            throw new IllegalArgumentException();
        }
        this.tagMap = tagMap;
    }

    public MapBasedTagGroup(Iterable<Tag> tags) {
        if (tags == null) {
            throw new IllegalArgumentException();
        }
        this.tagMap = new HashMap<String, String>();
        for (Tag tag : tags) {
            if (tag == null) {
                throw new IllegalArgumentException();
            }
            this.tagMap.put(tag.key, tag.value);
        }
    }

    public MapBasedTagGroup(Tag ... tags) {
        this.tagMap = new HashMap<String, String>(tags.length);
        for (Tag tag : tags) {
            if (tag == null) {
                throw new IllegalArgumentException();
            }
            this.tagMap.put(tag.key, tag.value);
        }
    }

    @Override
    public String getValue(String key) {
        assert (key != null);
        return this.tagMap.get(key);
    }

    @Override
    public boolean containsKey(String key) {
        assert (key != null);
        return this.tagMap.containsKey(key);
    }

    @Override
    public boolean containsValue(String value) {
        assert (value != null);
        return this.tagMap.containsValue(value);
    }

    @Override
    public boolean contains(Tag tag) {
        assert (tag != null);
        return tag.value.equals(this.tagMap.get(tag.key));
    }

    @Override
    public int size() {
        return this.tagMap.size();
    }

    @Override
    public Iterator<Tag> iterator() {
        LinkedList<Tag> tagCollection = new LinkedList<Tag>();
        for (String key : this.tagMap.keySet()) {
            tagCollection.add(new Tag(key, this.tagMap.get(key)));
        }
        return Collections.unmodifiableCollection(tagCollection).iterator();
    }

    public String toString() {
        return this.tagMap.toString();
    }
}

