/*
 * Decompiled with CFR 0.152.
 */
package seachart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.Action;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import render.ChartContext;
import render.Renderer;
import s57.S57map;
import s57.S57obj;
import seachart.SeachartAction;
import symbols.Symbols;

public class ChartImage
extends ImageryLayer
implements NavigatableComponent.ZoomChangeListener,
ChartContext {
    double top;
    double bottom;
    double left;
    double right;
    double width;
    double height;
    int zoom;

    public ChartImage(ImageryInfo info) {
        super(info);
        MapView.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
        this.zoomChanged();
    }

    public Action[] getMenuEntries() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    public void paint(Graphics2D g2, MapView mv, Bounds bb) {
        Rectangle rect = Main.map.mapView.getBounds();
        Renderer.reRender(g2, rect, this.zoom, Math.pow(2.0, this.zoom - 12), SeachartAction.map, this);
        g2.setPaint(Color.black);
        g2.setFont(new Font("Arial", 1, 20));
        Rectangle crect = g2.getClipBounds();
        if (crect.y + crect.height < rect.y + rect.height - 10) {
            g2.drawString("Z" + this.zoom, crect.x + crect.width - 40, crect.y + crect.height - 10);
        } else {
            g2.drawString("Z" + this.zoom, rect.x + rect.width - 40, rect.y + rect.height - 10);
        }
    }

    public void zoomChanged() {
        if (Main.map != null && Main.map.mapView != null) {
            Bounds bounds = Main.map.mapView.getRealBounds();
            this.top = bounds.getMax().lat();
            this.bottom = bounds.getMin().lat();
            this.left = bounds.getMin().lon();
            this.right = bounds.getMax().lon();
            this.width = Main.map.mapView.getBounds().getWidth();
            this.height = Main.map.mapView.getBounds().getHeight();
            this.zoom = (int)Math.min(18L, Math.max(9L, Math.round(Math.floor(Math.log(1024.0 / bounds.asRect().height) / Math.log(2.0)))));
        }
    }

    @Override
    public Point2D.Double getPoint(S57map.Snode coord) {
        return (Point2D.Double)Main.map.mapView.getPoint2D(new LatLon(Math.toDegrees(coord.lat), Math.toDegrees(coord.lon)));
    }

    @Override
    public double mile(S57map.Feature feature) {
        return 185000.0 / Main.map.mapView.getDist100Pixel();
    }

    @Override
    public boolean clip() {
        return true;
    }

    @Override
    public Color background(S57map map) {
        if (map.features.containsKey((Object)S57obj.Obj.COALNE)) {
            for (S57map.Feature feature : (ArrayList)map.features.get((Object)S57obj.Obj.COALNE)) {
                if (feature.geom.prim == S57map.Pflag.POINT) break;
                S57map s57map = map;
                s57map.getClass();
                S57map.GeomIterator git = s57map.new S57map.GeomIterator(feature.geom);
                git.nextComp();
                while (git.hasEdge()) {
                    git.nextEdge();
                    while (git.hasNode()) {
                        S57map.Snode node = git.next();
                        if (node == null || !(node.lat >= map.bounds.minlat) || !(node.lat <= map.bounds.maxlat) || !(node.lon >= map.bounds.minlon) || !(node.lon <= map.bounds.maxlon)) continue;
                        return Symbols.Bwater;
                    }
                }
            }
            return Symbols.Yland;
        }
        if (map.features.containsKey((Object)S57obj.Obj.ROADWY) || map.features.containsKey((Object)S57obj.Obj.RAILWY) || map.features.containsKey((Object)S57obj.Obj.LAKARE) || map.features.containsKey((Object)S57obj.Obj.RIVERS) || map.features.containsKey((Object)S57obj.Obj.CANALS)) {
            return Symbols.Yland;
        }
        return Symbols.Bwater;
    }

    @Override
    public ChartContext.RuleSet ruleset() {
        return ChartContext.RuleSet.ALL;
    }
}

