/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.search;

import java.util.Arrays;
import java.util.Collection;
import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.plugins.utilsplugin2.search.ChildrenMatch;
import org.openstreetmap.josm.plugins.utilsplugin2.search.ParentsMatch;
import org.openstreetmap.josm.plugins.utilsplugin2.search.UsedInRelationsMatch;
import org.openstreetmap.josm.plugins.utilsplugin2.search.UsedInWaysMatch;

public class UtilsSimpleMatchFactory
implements SearchCompiler.SimpleMatchFactory {
    private static Collection<String> keywords = Arrays.asList("usedinways", "usedinrelations", "parents", "children");

    public Collection<String> getKeywords() {
        return keywords;
    }

    public SearchCompiler.Match get(String keyword, PushbackTokenizer tokenizer) throws SearchCompiler.ParseError {
        if ("usedinways".equals(keyword)) {
            return new UsedInWaysMatch(tokenizer);
        }
        if ("usedinrelations".equals(keyword)) {
            return new UsedInRelationsMatch(tokenizer);
        }
        if ("parents".equals(keyword)) {
            return new ParentsMatch(tokenizer);
        }
        if ("children".equals(keyword)) {
            return new ChildrenMatch(tokenizer);
        }
        return null;
    }
}

