/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.command;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;

public class ChangeRelationMemberCommand
extends Command {
    private final Relation relation;
    private final OsmPrimitive oldMember;
    private final OsmPrimitive newMember;
    private boolean oldModified;

    public ChangeRelationMemberCommand(Relation relation, OsmPrimitive oldMember, OsmPrimitive newMember) {
        this.relation = relation;
        this.oldMember = oldMember;
        this.newMember = newMember;
    }

    private void replaceMembers(OsmPrimitive oldP, OsmPrimitive newP) {
        if (this.relation == null || this.oldMember == null || this.newMember == null) {
            return;
        }
        LinkedList<RelationMember> newrms = new LinkedList<RelationMember>();
        for (RelationMember rm : this.relation.getMembers()) {
            if (Objects.equals(rm.getMember(), oldP)) {
                newrms.add(new RelationMember(rm.getRole(), newP));
                continue;
            }
            newrms.add(rm);
        }
        this.relation.setMembers(newrms);
    }

    public boolean executeCommand() {
        this.oldModified = this.relation.isModified();
        this.replaceMembers(this.oldMember, this.newMember);
        this.relation.setModified(true);
        return true;
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add((OsmPrimitive)this.relation);
    }

    public void undoCommand() {
        this.replaceMembers(this.newMember, this.oldMember);
        this.relation.setModified(this.oldModified);
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Change relation member for {0} {1}", (Object[])new Object[]{OsmPrimitiveType.from((IPrimitive)this.relation), this.relation.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
    }
}

