/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import javax.swing.Action;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.measurement.MeasurementDialog;
import org.openstreetmap.josm.plugins.measurement.MeasurementLayer;
import org.openstreetmap.josm.plugins.measurement.MeasurementMode;
import org.openstreetmap.josm.tools.I18n;

public class MeasurementPlugin
extends Plugin {
    private IconToggleButton btn;
    private MeasurementMode mode;
    protected static MeasurementDialog measurementDialog;
    protected static MeasurementLayer currentLayer;

    public MeasurementPlugin(PluginInformation info) {
        super(info);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            measurementDialog = new MeasurementDialog();
            newFrame.addToggleDialog((ToggleDialog)measurementDialog);
            this.mode = new MeasurementMode(newFrame, "measurement", I18n.tr((String)"measurement mode", (Object[])new Object[0]));
            this.btn = new IconToggleButton((Action)((Object)this.mode));
            this.btn.setVisible(true);
            newFrame.addMapMode(this.btn);
        } else {
            this.btn = null;
            this.mode = null;
            measurementDialog = null;
        }
    }

    public static MeasurementLayer getCurrentLayer() {
        if (currentLayer == null) {
            currentLayer = new MeasurementLayer(I18n.tr((String)"Measurements", (Object[])new Object[0]));
            Main.getLayerManager().addLayer((Layer)currentLayer);
            final MainLayerManager.ActiveLayerChangeListener activeListener = new MainLayerManager.ActiveLayerChangeListener(){

                public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
                    Layer newLayer = Main.getLayerManager().getActiveLayer();
                    if (newLayer instanceof MeasurementLayer) {
                        currentLayer = (MeasurementLayer)newLayer;
                    }
                }
            };
            Main.getLayerManager().addActiveLayerChangeListener(activeListener);
            Main.getLayerManager().addLayerChangeListener(new LayerManager.LayerChangeListener(){

                public void layerAdded(LayerManager.LayerAddEvent e) {
                }

                public void layerRemoving(LayerManager.LayerRemoveEvent e) {
                    Layer oldLayer = e.getRemovedLayer();
                    if (oldLayer != null && oldLayer == currentLayer) {
                        Main.getLayerManager().removeActiveLayerChangeListener(activeListener);
                        Main.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
                    }
                }

                public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
                }
            });
        }
        return currentLayer;
    }
}

