/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Debouncer {
    private final ScheduledExecutorService scheduler;
    private final ConcurrentHashMap<Object, Future<?>> delayedMap = new ConcurrentHashMap();

    public Debouncer(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public void debounce(final Object key, final Runnable runnable, long delay, TimeUnit unit) {
        Future prev = this.delayedMap.put(key, this.scheduler.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    Debouncer.this.delayedMap.remove(key);
                }
            }
        }, delay, unit));
        if (prev != null) {
            prev.cancel(true);
        }
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
    }
}

