/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.ScalarConstantPtg;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class BoolPtg
extends ScalarConstantPtg {
    public static final int SIZE = 2;
    public static final byte sid = 29;
    private static final BoolPtg FALSE = new BoolPtg(false);
    private static final BoolPtg TRUE = new BoolPtg(true);
    private final boolean _value;

    private BoolPtg(boolean bl) {
        this._value = bl;
    }

    public static BoolPtg valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static BoolPtg read(LittleEndianInput littleEndianInput) {
        return BoolPtg.valueOf(littleEndianInput.readByte() == 1);
    }

    @Override
    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(29 + this.getPtgClass());
        littleEndianOutput.writeByte(this._value ? 1 : 0);
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public String toFormulaString() {
        return this._value ? "TRUE" : "FALSE";
    }
}

