/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class ColumnInfoRecord
extends StandardRecord {
    public static final short sid = 125;
    private int _firstCol;
    private int _lastCol;
    private int _colWidth;
    private int _xfIndex;
    private int _options;
    private static final BitField hidden = BitFieldFactory.getInstance(1);
    private static final BitField outlevel = BitFieldFactory.getInstance(1792);
    private static final BitField collapsed = BitFieldFactory.getInstance(4096);
    private int field_6_reserved;

    public ColumnInfoRecord() {
        this.setColumnWidth(2275);
        this._options = 2;
        this._xfIndex = 15;
        this.field_6_reserved = 2;
    }

    public ColumnInfoRecord(RecordInputStream recordInputStream) {
        this._firstCol = recordInputStream.readUShort();
        this._lastCol = recordInputStream.readUShort();
        this._colWidth = recordInputStream.readUShort();
        this._xfIndex = recordInputStream.readUShort();
        this._options = recordInputStream.readUShort();
        switch (recordInputStream.remaining()) {
            case 2: {
                this.field_6_reserved = recordInputStream.readUShort();
                break;
            }
            case 1: {
                this.field_6_reserved = recordInputStream.readByte();
                break;
            }
            case 0: {
                this.field_6_reserved = 0;
                break;
            }
            default: {
                throw new RuntimeException("Unusual record size remaining=(" + recordInputStream.remaining() + ")");
            }
        }
    }

    public void setColumnWidth(int n) {
        this._colWidth = n;
    }

    public int getFirstColumn() {
        return this._firstCol;
    }

    public int getLastColumn() {
        return this._lastCol;
    }

    public int getColumnWidth() {
        return this._colWidth;
    }

    public int getXFIndex() {
        return this._xfIndex;
    }

    public boolean getHidden() {
        return hidden.isSet(this._options);
    }

    public int getOutlineLevel() {
        return outlevel.getValue(this._options);
    }

    public boolean getCollapsed() {
        return collapsed.isSet(this._options);
    }

    public boolean containsColumn(int n) {
        return this._firstCol <= n && n <= this._lastCol;
    }

    public boolean isAdjacentBefore(ColumnInfoRecord columnInfoRecord) {
        return this._lastCol == columnInfoRecord._firstCol - 1;
    }

    public boolean formatMatches(ColumnInfoRecord columnInfoRecord) {
        if (this._xfIndex != columnInfoRecord._xfIndex) {
            return false;
        }
        if (this._options != columnInfoRecord._options) {
            return false;
        }
        return this._colWidth == columnInfoRecord._colWidth;
    }

    @Override
    public short getSid() {
        return 125;
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getFirstColumn());
        littleEndianOutput.writeShort(this.getLastColumn());
        littleEndianOutput.writeShort(this.getColumnWidth());
        littleEndianOutput.writeShort(this.getXFIndex());
        littleEndianOutput.writeShort(this._options);
        littleEndianOutput.writeShort(this.field_6_reserved);
    }

    @Override
    protected int getDataSize() {
        return 12;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[COLINFO]\n");
        stringBuilder.append("  colfirst = ").append(this.getFirstColumn()).append("\n");
        stringBuilder.append("  collast  = ").append(this.getLastColumn()).append("\n");
        stringBuilder.append("  colwidth = ").append(this.getColumnWidth()).append("\n");
        stringBuilder.append("  xfindex  = ").append(this.getXFIndex()).append("\n");
        stringBuilder.append("  options  = ").append(HexDump.shortToHex(this._options)).append("\n");
        stringBuilder.append("    hidden   = ").append(this.getHidden()).append("\n");
        stringBuilder.append("    olevel   = ").append(this.getOutlineLevel()).append("\n");
        stringBuilder.append("    collapsed= ").append(this.getCollapsed()).append("\n");
        stringBuilder.append("[/COLINFO]\n");
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        ColumnInfoRecord columnInfoRecord = new ColumnInfoRecord();
        columnInfoRecord._firstCol = this._firstCol;
        columnInfoRecord._lastCol = this._lastCol;
        columnInfoRecord._colWidth = this._colWidth;
        columnInfoRecord._xfIndex = this._xfIndex;
        columnInfoRecord._options = this._options;
        columnInfoRecord.field_6_reserved = this.field_6_reserved;
        return columnInfoRecord;
    }
}

