/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.List;
import org.apache.poi.hssf.record.Record;

public final class RecordStream {
    private final List<Record> _list;
    private int _nextIndex;
    private int _countRead;
    private final int _endIx;

    public RecordStream(List<Record> list, int n, int n2) {
        this._list = list;
        this._nextIndex = n;
        this._endIx = n2;
        this._countRead = 0;
    }

    public RecordStream(List<Record> list, int n) {
        this(list, n, list.size());
    }

    public boolean hasNext() {
        return this._nextIndex < this._endIx;
    }

    public Record getNext() {
        if (!this.hasNext()) {
            throw new RuntimeException("Attempt to read past end of record stream");
        }
        ++this._countRead;
        return this._list.get(this._nextIndex++);
    }

    public Class<? extends Record> peekNextClass() {
        if (!this.hasNext()) {
            return null;
        }
        return this._list.get(this._nextIndex).getClass();
    }

    public int peekNextSid() {
        if (!this.hasNext()) {
            return -1;
        }
        return this._list.get(this._nextIndex).getSid();
    }

    public int getCountRead() {
        return this._countRead;
    }
}

