/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.Date;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.temporal.object.DefaultTemporalGeometricPrimitive;
import org.geotools.util.Utilities;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;

public class DefaultPeriod
extends DefaultTemporalGeometricPrimitive
implements Period {
    private Instant begining;
    private Instant ending;

    public DefaultPeriod(Instant begining, Instant ending) {
        if (!begining.relativePosition(ending).equals(RelativePosition.BEFORE)) {
            throw new IllegalArgumentException("The temporal position of the beginning of the period must be less than (i.e. earlier than) the temporal position of the end of the period");
        }
        this.begining = begining;
        this.ending = ending;
    }

    @Override
    public Instant getBeginning() {
        return this.begining;
    }

    public void setBegining(Instant begining) {
        this.begining = begining;
    }

    public void setBegining(Date date) {
        this.begining = new DefaultInstant(new DefaultPosition(date));
    }

    @Override
    public Instant getEnding() {
        return this.ending;
    }

    public void setEnding(Instant ending) {
        this.ending = ending;
    }

    public void setEnding(Date date) {
        this.ending = new DefaultInstant(new DefaultPosition(date));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultPeriod) {
            DefaultPeriod that = (DefaultPeriod)object;
            return Utilities.equals(this.begining, that.begining) && Utilities.equals(this.ending, that.ending);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.begining != null ? this.begining.hashCode() : 0);
        hash = 37 * hash + (this.ending != null ? this.ending.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Period:").append('\n');
        if (this.begining != null) {
            s.append("begin:").append(this.begining).append('\n');
        }
        if (this.ending != null) {
            s.append("end:").append(this.ending).append('\n');
        }
        return s.toString();
    }
}

