/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.media.jai.JAI;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpCubic;
import javax.media.jai.WarpGeneralPolynomial;
import javax.media.jai.WarpPolynomial;
import javax.media.jai.WarpQuadratic;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.WarpAdapter;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;

public class WarpTransform2D
extends AbstractMathTransform
implements MathTransform2D,
Serializable {
    private static final long serialVersionUID = -7949539694656719923L;
    private static final boolean USE_HACK;
    public static final int MAX_DEGREE = 7;
    private final Warp warp;
    private final WarpTransform2D inverse;

    public WarpTransform2D(Point2D[] srcCoords, Point2D[] dstCoords, int degree) {
        this(null, srcCoords, 0, null, dstCoords, 0, Math.min(srcCoords.length, dstCoords.length), degree);
    }

    public WarpTransform2D(Rectangle2D srcBounds, Point2D[] srcCoords, int srcOffset, Rectangle2D dstBounds, Point2D[] dstCoords, int dstOffset, int numCoords, int degree) {
        this(srcBounds, WarpTransform2D.toFloat(srcCoords, srcOffset, numCoords), 0, dstBounds, WarpTransform2D.toFloat(dstCoords, dstOffset, numCoords), 0, numCoords, degree, false);
    }

    private static float[] toFloat(Point2D[] points, int offset, int numCoords) {
        float[] array = new float[numCoords * 2];
        int i = 0;
        while (i < array.length) {
            Point2D point = points[offset++];
            array[i++] = (float)point.getX();
            array[i++] = (float)point.getY();
        }
        return array;
    }

    public WarpTransform2D(Rectangle2D srcBounds, float[] srcCoords, int srcOffset, Rectangle2D dstBounds, float[] dstCoords, int dstOffset, int numCoords, int degree) {
        this(srcBounds, srcCoords, srcOffset, dstBounds, dstCoords, dstOffset, numCoords, degree, true);
    }

    private WarpTransform2D(Rectangle2D srcBounds, float[] srcCoords, int srcOffset, Rectangle2D dstBounds, float[] dstCoords, int dstOffset, int numCoords, int degree, boolean cloneCoords) {
        float postScaleY;
        float postScaleX;
        float preScaleY;
        float preScaleX;
        if (srcBounds != null) {
            preScaleX = (float)srcBounds.getWidth();
            preScaleY = (float)srcBounds.getHeight();
        } else {
            preScaleX = WarpTransform2D.getWidth(srcCoords, srcOffset, numCoords);
            preScaleY = WarpTransform2D.getWidth(srcCoords, srcOffset + 1, numCoords);
        }
        if (dstBounds != null) {
            postScaleX = (float)dstBounds.getWidth();
            postScaleY = (float)dstBounds.getHeight();
        } else {
            postScaleX = WarpTransform2D.getWidth(dstCoords, dstOffset, numCoords);
            postScaleY = WarpTransform2D.getWidth(dstCoords, dstOffset + 1, numCoords);
        }
        if (USE_HACK) {
            double scaleX = preScaleX / postScaleX;
            double scaleY = preScaleY / postScaleY;
            if (scaleX != 1.0 || scaleY != 1.0) {
                int n = numCoords * 2;
                if (cloneCoords) {
                    float[] o = srcCoords;
                    srcCoords = new float[n];
                    System.arraycopy(o, srcOffset, srcCoords, 0, n);
                    srcOffset = 0;
                    o = dstCoords;
                    dstCoords = new float[n];
                    System.arraycopy(o, dstOffset, dstCoords, 0, n);
                    dstOffset = 0;
                }
                int i = 0;
                while (i < n) {
                    int n2 = srcOffset + i;
                    srcCoords[n2] = (float)((double)srcCoords[n2] / scaleX);
                    int n3 = dstOffset + i++;
                    dstCoords[n3] = (float)((double)dstCoords[n3] * scaleX);
                    int n4 = srcOffset + i;
                    srcCoords[n4] = (float)((double)srcCoords[n4] / scaleY);
                    int n5 = dstOffset + i++;
                    dstCoords[n5] = (float)((double)dstCoords[n5] * scaleY);
                }
            }
        }
        this.warp = WarpPolynomial.createWarp(dstCoords, dstOffset, srcCoords, srcOffset, numCoords, 1.0f / preScaleX, 1.0f / preScaleY, postScaleX, postScaleY, degree);
        this.inverse = new WarpTransform2D((Warp)WarpPolynomial.createWarp(srcCoords, srcOffset, dstCoords, dstOffset, numCoords, 1.0f / postScaleX, 1.0f / postScaleY, preScaleX, preScaleY, degree), this);
    }

    private static float getWidth(float[] array, int offset, int num) {
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        while (--num >= 0) {
            float value = array[offset];
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            offset += 2;
        }
        return max - min;
    }

    protected WarpTransform2D(Warp warp, Warp inverse) {
        WarpTransform2D.ensureNonNull("warp", warp);
        this.warp = warp;
        this.inverse = inverse != null ? new WarpTransform2D(inverse, this) : null;
    }

    private WarpTransform2D(Warp warp, WarpTransform2D inverse) {
        this.warp = warp;
        this.inverse = inverse;
    }

    public static MathTransform2D create(Warp warp) {
        if (warp instanceof WarpAdapter) {
            return ((WarpAdapter)warp).getTransform();
        }
        return new WarpTransform2D(warp, (Warp)null);
    }

    public static Warp getWarp(CharSequence name, MathTransform2D transform) {
        if (transform instanceof WarpTransform2D) {
            return ((WarpTransform2D)transform).getWarp();
        }
        if (name == null) {
            name = Vocabulary.formatInternational(252);
        }
        return new WarpAdapter(name, transform);
    }

    public Warp getWarp() {
        return this.warp;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        if (this.warp instanceof WarpPolynomial) {
            return Provider.PARAMETERS;
        }
        return super.getParameterDescriptors();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        if (this.warp instanceof WarpPolynomial) {
            WarpPolynomial poly = (WarpPolynomial)this.warp;
            ParameterValue[] p = new ParameterValue[7];
            int c = 0;
            p[c++] = new Parameter<Integer>(Provider.DEGREE, poly.getDegree());
            p[c++] = new Parameter<float[]>(Provider.X_COEFFS, poly.getXCoeffs());
            p[c++] = new Parameter<float[]>(Provider.Y_COEFFS, poly.getYCoeffs());
            float s = poly.getPreScaleX();
            if (s != 1.0f) {
                p[c++] = new Parameter<Float>(Provider.PRE_SCALE_X, Float.valueOf(s));
            }
            if ((s = poly.getPreScaleY()) != 1.0f) {
                p[c++] = new Parameter<Float>(Provider.PRE_SCALE_Y, Float.valueOf(s));
            }
            if ((s = poly.getPostScaleX()) != 1.0f) {
                p[c++] = new Parameter<Float>(Provider.POST_SCALE_X, Float.valueOf(s));
            }
            if ((s = poly.getPostScaleY()) != 1.0f) {
                p[c++] = new Parameter<Float>(Provider.POST_SCALE_Y, Float.valueOf(s));
            }
            return new ParameterGroup(this.getParameterDescriptors(), (GeneralParameterValue[])XArray.resize(p, c));
        }
        return super.getParameterValues();
    }

    @Override
    public int getSourceDimensions() {
        return 2;
    }

    @Override
    public int getTargetDimensions() {
        return 2;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    public Point2D transform(Point2D ptSrc, Point2D ptDst) {
        ptSrc = new PointDouble(ptSrc.getX() - 0.5, ptSrc.getY() - 0.5);
        Point2D result = this.warp.mapDestPoint(ptSrc);
        result.setLocation(result.getX() + 0.5, result.getY() + 0.5);
        if (ptDst == null) {
            ptDst = new Point2D.Float();
        }
        ptDst.setLocation(result);
        return ptDst;
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int postIncrement;
        if (srcPts == dstPts && srcOff < dstOff) {
            srcOff += (numPts - 1) * 2;
            dstOff += (numPts - 1) * 2;
            postIncrement = -4;
        } else {
            postIncrement = 0;
        }
        PointFloat ptSrc = new PointFloat();
        float[] ptDst = new float[2];
        while (--numPts >= 0) {
            ptSrc.x = srcPts[srcOff++] - 0.5f;
            ptSrc.y = srcPts[srcOff++] - 0.5f;
            Point2D result = this.warp.mapDestPoint(ptSrc);
            dstPts[dstOff++] = (float)(result.getX() + 0.5);
            dstPts[dstOff++] = (float)(result.getY() + 0.5);
            dstOff += postIncrement;
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int postIncrement;
        if (srcPts == dstPts && srcOff < dstOff) {
            srcOff += (numPts - 1) * 2;
            dstOff += (numPts - 1) * 2;
            postIncrement = -4;
        } else {
            postIncrement = 0;
        }
        PointDouble ptSrc = new PointDouble();
        float[] ptDst = new float[2];
        while (--numPts >= 0) {
            ptSrc.x = srcPts[srcOff++] - 0.5;
            ptSrc.y = srcPts[srcOff++] - 0.5;
            Point2D result = this.warp.mapDestPoint(ptSrc);
            dstPts[dstOff++] = result.getX() + 0.5;
            dstPts[dstOff++] = result.getY() + 0.5;
            dstOff += postIncrement;
        }
    }

    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse != null) {
            return this.inverse;
        }
        return (MathTransform2D)super.inverse();
    }

    @Override
    public int hashCode() {
        return 0x241E73CD ^ super.hashCode() ^ this.warp.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            WarpTransform2D that = (WarpTransform2D)object;
            return Utilities.equals(this.warp, that.warp);
        }
        return false;
    }

    static {
        String buildVersion = JAI.getBuildVersion();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd' 'hh:mm:ss.SSSZ");
        TimeZone tz = TimeZone.getTimeZone("UTC");
        df.setTimeZone(tz);
        boolean hack = false;
        try {
            Date date_ = buildVersion != null ? df.parse(buildVersion) : new Date();
            GregorianCalendar tempCal = new GregorianCalendar(tz);
            tempCal.setTime(date_);
            tempCal.set(11, 0);
            tempCal.set(12, 0);
            tempCal.set(13, 0);
            tempCal.set(14, 0);
            Date date = tempCal.getTime();
            GregorianCalendar version113 = new GregorianCalendar(tz);
            version113.set(2006, 8, 12, 0, 0, 0);
            version113.set(14, 0);
            hack = !date.after(version113.getTime());
        }
        catch (ParseException e) {
            hack = false;
        }
        USE_HACK = hack;
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -7949539694656719923L;
        public static final ParameterDescriptor<Integer> DEGREE = DefaultParameterDescriptor.create("degree", 2, 1, 7);
        public static final ParameterDescriptor X_COEFFS = new DefaultParameterDescriptor<Object>("xCoeffs", float[].class, null, null);
        public static final ParameterDescriptor Y_COEFFS = new DefaultParameterDescriptor<Object>("yCoeffs", float[].class, null, null);
        public static final ParameterDescriptor PRE_SCALE_X;
        public static final ParameterDescriptor PRE_SCALE_Y;
        public static final ParameterDescriptor POST_SCALE_X;
        public static final ParameterDescriptor<Float> POST_SCALE_Y;
        static final ParameterDescriptorGroup PARAMETERS;

        public Provider() {
            super(2, 2, PARAMETERS);
        }

        public Class<Transformation> getOperationType() {
            return Transformation.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            WarpPolynomial warp;
            int degree = Provider.intValue(DEGREE, values);
            float[] xCoeffs = (float[])Provider.value(X_COEFFS, values);
            float[] yCoeffs = (float[])Provider.value(Y_COEFFS, values);
            float preScaleX = Provider.scale(PRE_SCALE_X, values);
            float preScaleY = Provider.scale(PRE_SCALE_Y, values);
            float postScaleX = Provider.scale(POST_SCALE_X, values);
            float postScaleY = Provider.scale(POST_SCALE_Y, values);
            switch (degree) {
                case 1: {
                    warp = new WarpAffine(xCoeffs, yCoeffs, preScaleX, preScaleY, postScaleX, postScaleY);
                    break;
                }
                case 2: {
                    warp = new WarpQuadratic(xCoeffs, yCoeffs, preScaleX, preScaleY, postScaleX, postScaleY);
                    break;
                }
                case 3: {
                    warp = new WarpCubic(xCoeffs, yCoeffs, preScaleX, preScaleY, postScaleX, postScaleY);
                    break;
                }
                default: {
                    warp = new WarpGeneralPolynomial(xCoeffs, yCoeffs, preScaleX, preScaleY, postScaleX, postScaleY);
                }
            }
            return new WarpTransform2D((Warp)warp, (Warp)null);
        }

        private static float scale(ParameterDescriptor param, ParameterValueGroup group) throws ParameterNotFoundException {
            Object value = Provider.value(param, group);
            return value != null ? ((Number)value).floatValue() : 1.0f;
        }

        static {
            Float ONE = Float.valueOf(1.0f);
            PRE_SCALE_X = DefaultParameterDescriptor.create("preScaleX", null, Float.class, ONE, false);
            PRE_SCALE_Y = DefaultParameterDescriptor.create("preScaleY", null, Float.class, ONE, false);
            POST_SCALE_X = DefaultParameterDescriptor.create("postScaleX", null, Float.class, ONE, false);
            POST_SCALE_Y = DefaultParameterDescriptor.create("postScaleY", null, Float.class, ONE, false);
            PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "WarpPolynomial")}, new ParameterDescriptor[]{DEGREE, X_COEFFS, Y_COEFFS, PRE_SCALE_X, PRE_SCALE_Y, POST_SCALE_X, POST_SCALE_Y});
        }
    }

    private static final class PointDouble
    extends Point2D.Double {
        public PointDouble() {
        }

        public PointDouble(double x, double y) {
            super(x, y);
        }

        @Override
        public PointDouble clone() {
            return this;
        }
    }

    private static final class PointFloat
    extends Point2D.Float {
        private PointFloat() {
        }

        @Override
        public PointFloat clone() {
            return this;
        }
    }
}

