/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geojson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import javax.swing.JOptionPane;
import org.geojson.GeoJsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.plugins.geojson.DataSetBuilder;
import org.openstreetmap.josm.plugins.geojson.GeoJsonLayer;
import org.openstreetmap.josm.tools.I18n;

public class GeoJsonFileImporter
extends FileImporter {
    public GeoJsonFileImporter() {
        super(new ExtensionFileFilter("geojson,json", "geojson", I18n.tr((String)"GeoJSON file", (Object[])new Object[0]) + " (*.geojson,*.json)"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(File file, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr((String)"Loading json file...", (Object[])new Object[0]));
        progressMonitor.setTicksCount(2);
        Main.info((String)("Parsing GeoJSON: " + file.getAbsolutePath()));
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            GeoJsonObject object = mapper.readValue(file, GeoJsonObject.class);
            progressMonitor.worked(1);
            DataSetBuilder.BoundedDataSet data = new DataSetBuilder().build(object);
            GeoJsonLayer layer = new GeoJsonLayer(I18n.tr((String)"Data Layer from GeoJSON: ", (Object[])new Object[0]) + file.getName(), data);
            Main.getLayerManager().addLayer((Layer)layer);
        }
        catch (Exception e) {
            Main.error((String)"Error while reading json file!", (Object[])new Object[]{e});
            JOptionPane.showMessageDialog(null, I18n.tr((String)"Error loading geojson file {0}", (Object[])new Object[]{file.getAbsolutePath()}), I18n.tr((String)"Error", (Object[])new Object[0]), 2);
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

