/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.cache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;

public class MapillaryCache
extends JCSCachedTileLoaderJob<String, BufferedImageCacheEntry> {
    private final URL url;
    private final String key;

    public MapillaryCache(String key, Type type) {
        super(MapillaryPlugin.cache, 50000, 50000, new HashMap());
        String k = null;
        URL u = null;
        if (key != null && type != null) {
            try {
                switch (type) {
                    case FULL_IMAGE: {
                        k = key + ".FULL_IMAGE";
                        u = new URL("https://d1cuyjsrcm0gby.cloudfront.net/" + key + "/thumb-2048.jpg");
                        break;
                    }
                    default: {
                        k = key + ".THUMBNAIL";
                        u = new URL("https://d1cuyjsrcm0gby.cloudfront.net/" + key + "/thumb-320.jpg");
                        break;
                    }
                }
            }
            catch (MalformedURLException e) {
                Main.error((Throwable)e);
            }
        }
        this.key = k;
        this.url = u;
    }

    public String getCacheKey() {
        return this.key;
    }

    public URL getUrl() {
        return this.url;
    }

    protected BufferedImageCacheEntry createCacheEntry(byte[] content) {
        return new BufferedImageCacheEntry(content);
    }

    protected boolean isObjectLoadable() {
        if (this.cacheData == null) {
            return false;
        }
        byte[] content = ((BufferedImageCacheEntry)this.cacheData).getContent();
        return content != null && content.length > 0;
    }

    public static enum Type {
        FULL_IMAGE,
        THUMBNAIL;

    }
}

