/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;
import org.wikipedia.FetchWikidataAction;
import org.wikipedia.GuiUtils;
import org.wikipedia.WikipediaApp;
import org.wikipedia.WikipediaCategorySearchDialog;

public class WikipediaToggleDialog
extends ToggleDialog
implements MainLayerManager.ActiveLayerChangeListener,
DataSetListenerAdapter.Listener {
    String titleContext = null;
    static final StringProperty wikipediaLang = new StringProperty("wikipedia.lang", LanguageInfo.getJOSMLocaleCode().substring(0, 2));
    final Set<String> articles = new HashSet<String>();
    final DefaultListModel<WikipediaApp.WikipediaEntry> model = new DefaultListModel();
    final JList<WikipediaApp.WikipediaEntry> list = new JList<WikipediaApp.WikipediaEntry>(this.model){
        {
            this.setToolTipText(I18n.tr((String)"Double click on item to search for object with article name (and center coordinate)", (Object[])new Object[0]));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && this.getSelectedValue() != null) {
                        WikipediaApp.WikipediaEntry entry = (WikipediaApp.WikipediaEntry)this.getSelectedValue();
                        if (entry.coordinate != null) {
                            BoundingXYVisitor bbox = new BoundingXYVisitor();
                            bbox.visit(entry.coordinate);
                            Main.map.mapView.zoomTo(bbox);
                        }
                        String search = ((String)Utils.firstNonNull((Object[])new String[]{entry.label, entry.wikipediaArticle})).replaceAll("\\(.*\\)", "");
                        SearchAction.search((String)search, (SearchAction.SearchMode)SearchAction.SearchMode.replace);
                    }
                }
            });
            this.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public JLabel getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    WikipediaApp.WikipediaEntry entry = (WikipediaApp.WikipediaEntry)value;
                    String labelText = "<html>" + entry.getLabelText();
                    JLabel label = (JLabel)super.getListCellRendererComponent(list, labelText, index, isSelected, cellHasFocus);
                    if (entry.getWiwosmStatus() != null && entry.getWiwosmStatus().booleanValue()) {
                        label.setIcon(ImageProvider.getIfAvailable((String)"misc", (String)"grey_check"));
                        label.setToolTipText(I18n.tr((String)"Available via WIWOSM server", (Object[])new Object[0]));
                    } else if (WikipediaToggleDialog.this.articles.contains(entry.wikipediaArticle)) {
                        label.setIcon(ImageProvider.getIfAvailable((String)"misc", (String)"green_check"));
                        label.setToolTipText(I18n.tr((String)"Available in local dataset", (Object[])new Object[0]));
                    } else {
                        label.setToolTipText(I18n.tr((String)"Not linked yet", (Object[])new Object[0]));
                    }
                    return label;
                }
            });
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(new OpenWikipediaArticleAction());
            popupMenu.add(new ZoomToWikipediaArticleAction());
            this.setComponentPopupMenu(popupMenu);
        }
    };
    private final DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter((DataSetListenerAdapter.Listener)this);

    public WikipediaToggleDialog() {
        super(I18n.tr((String)"Wikipedia", (Object[])new Object[0]), "wikipedia", I18n.tr((String)"Fetch Wikipedia articles with coordinates", (Object[])new Object[0]), null, 150);
        this.createLayout(this.list, true, Arrays.asList(new SideButton((Action)new WikipediaLoadCoordinatesAction(false)), new SideButton((Action)new WikipediaLoadCoordinatesAction(true)), new SideButton((Action)new WikipediaLoadCategoryAction()), new SideButton((Action)new PasteWikipediaArticlesAction()), new SideButton((Action)new AddWikipediaTagAction(this.list)), new SideButton((Action)new WikipediaSettingsAction(), false)));
        this.updateTitle();
    }

    private void updateTitle() {
        String lang = this.getLanguageOfFirstItem();
        String host = WikipediaApp.getSiteUrl(lang).split("/+")[1];
        if (this.titleContext == null) {
            this.setTitle(host);
        } else {
            this.setTitle(I18n.tr((String)"{0}: {1}", (Object[])new Object[]{host, this.titleContext}));
        }
    }

    private String getLanguageOfFirstItem() {
        try {
            return this.list.getModel().getElementAt((int)0).wikipediaLang;
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            return wikipediaLang.get();
        }
    }

    protected void updateWikipediaArticles() {
        String language = this.getLanguageOfFirstItem();
        this.articles.clear();
        if (Main.main != null && Main.getLayerManager().getEditDataSet() != null) {
            for (OsmPrimitive p : Main.getLayerManager().getEditDataSet().allPrimitives()) {
                this.articles.addAll(WikipediaApp.getWikipediaArticles(language, p));
            }
        }
    }

    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        Main.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        this.updateWikipediaArticles();
    }

    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener((DataSetListener)this.dataChangedAdapter);
        Main.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        this.articles.clear();
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.updateWikipediaArticles();
        this.list.repaint();
    }

    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.updateWikipediaArticles();
        this.list.repaint();
    }

    class ZoomToWikipediaArticleAction
    extends AbstractAction {
        ZoomToWikipediaArticleAction() {
            super(I18n.tr((String)"Zoom to selection", (Object[])new Object[0]));
            new ImageProvider("dialogs/autoscale", "selection").getResource().attachImageIcon((AbstractAction)this);
            this.putValue("ShortDescription", I18n.tr((String)"Zoom to selection", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LatLon latLon;
            WikipediaApp.WikipediaEntry entry = WikipediaToggleDialog.this.list.getSelectedValue();
            if (entry == null) {
                return;
            }
            LatLon latLon2 = latLon = entry.coordinate != null ? entry.coordinate : WikipediaApp.getCoordinateForArticle(entry.wikipediaLang, entry.wikipediaArticle);
            if (latLon == null) {
                return;
            }
            Main.map.mapView.zoomTo(latLon);
        }
    }

    static class AddWikipediaTagAction
    extends AbstractAction {
        private final JList<WikipediaApp.WikipediaEntry> list;

        public AddWikipediaTagAction(JList<WikipediaApp.WikipediaEntry> list) {
            super(I18n.tr((String)"Add Tag", (Object[])new Object[0]));
            this.list = list;
            new ImageProvider("pastetags").getResource().attachImageIcon((AbstractAction)this, true);
            this.putValue("ShortDescription", I18n.tr((String)"Adds a ''wikipedia'' tag corresponding to this article to the selected objects", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddWikipediaTagAction.addTag(this.list.getSelectedValue());
        }

        static void addTag(WikipediaApp.WikipediaEntry entry) {
            if (entry == null) {
                return;
            }
            AddWikipediaTagAction.addTag(entry.createWikipediaTag());
        }

        static void addTag(Tag tag) {
            if (tag == null) {
                return;
            }
            Collection selected = Main.getLayerManager().getEditDataSet().getSelected();
            if (!GuiUtils.confirmOverwrite(tag.getKey(), tag.getValue(), selected)) {
                return;
            }
            ChangePropertyCommand cmd = new ChangePropertyCommand(selected, tag.getKey(), tag.getValue());
            Main.main.undoRedo.add((Command)cmd);
            Main.worker.submit((Runnable)((Object)new FetchWikidataAction.Fetcher(selected)));
        }
    }

    class WikipediaSettingsAction
    extends AbstractAction {
        public WikipediaSettingsAction() {
            super(I18n.tr((String)"Language", (Object[])new Object[0]));
            new ImageProvider("dialogs/settings").getResource().attachImageIcon((AbstractAction)this, true);
            this.putValue("ShortDescription", I18n.tr((String)"Sets the default language for the Wikipedia articles", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String lang = JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"Enter the Wikipedia language", (Object[])new Object[0]), wikipediaLang.get());
            if (lang != null) {
                wikipediaLang.put(lang);
                WikipediaToggleDialog.this.updateTitle();
                WikipediaToggleDialog.this.updateWikipediaArticles();
            }
        }
    }

    class OpenWikipediaArticleAction
    extends AbstractAction {
        public OpenWikipediaArticleAction() {
            super(I18n.tr((String)"Open Article", (Object[])new Object[0]));
            new ImageProvider("browser").getResource().attachImageIcon((AbstractAction)this);
            this.putValue("ShortDescription", I18n.tr((String)"Opens the Wikipedia article of the selected item in a browser", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WikipediaToggleDialog.this.list.getSelectedValue() != null) {
                String url = WikipediaToggleDialog.this.list.getSelectedValue().getBrowserUrl();
                Main.info((String)("Wikipedia: opening " + url));
                OpenBrowser.displayUrl((String)url);
            }
        }
    }

    class PasteWikipediaArticlesAction
    extends AbstractAction {
        public PasteWikipediaArticlesAction() {
            super(I18n.tr((String)"Clipboard", (Object[])new Object[0]));
            new ImageProvider("paste").getResource().attachImageIcon((AbstractAction)this, true);
            this.putValue("ShortDescription", I18n.tr((String)"Pastes Wikipedia articles from the system clipboard", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WikipediaToggleDialog.this.titleContext = I18n.tr((String)"clipboard", (Object[])new Object[0]);
            WikipediaToggleDialog.this.updateTitle();
            new UpdateWikipediaArticlesSwingWorker(){

                @Override
                List<WikipediaApp.WikipediaEntry> getEntries() {
                    return WikipediaApp.getEntriesFromClipboard(wikipediaLang.get());
                }
            }.execute();
        }
    }

    class WikipediaLoadCategoryAction
    extends AbstractAction {
        public WikipediaLoadCategoryAction() {
            super(I18n.tr((String)"Category", (Object[])new Object[0]));
            new ImageProvider("data", "sequence").getResource().attachImageIcon((AbstractAction)this, true);
            this.putValue("ShortDescription", I18n.tr((String)"Fetches a list of all Wikipedia articles of a category", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WikipediaCategorySearchDialog categorySearchDialog = WikipediaCategorySearchDialog.getInstance();
            categorySearchDialog.showDialog();
            if (categorySearchDialog.getValue() != 1) {
                return;
            }
            final String category = categorySearchDialog.getCategory();
            if (category == null) {
                return;
            }
            WikipediaToggleDialog.this.titleContext = category;
            WikipediaToggleDialog.this.updateTitle();
            new UpdateWikipediaArticlesSwingWorker(){

                @Override
                List<WikipediaApp.WikipediaEntry> getEntries() {
                    return WikipediaApp.getEntriesFromCategory(wikipediaLang.get(), category, Main.pref.getInteger("wikipedia.depth", 3));
                }
            }.execute();
        }
    }

    abstract class UpdateWikipediaArticlesSwingWorker
    extends SwingWorker<Void, WikipediaApp.WikipediaEntry> {
        private final IntegerProperty wikipediaStatusUpdateChunkSize = new IntegerProperty("wikipedia.statusupdate.chunk-size", 20);

        UpdateWikipediaArticlesSwingWorker() {
        }

        abstract List<WikipediaApp.WikipediaEntry> getEntries();

        @Override
        protected Void doInBackground() throws Exception {
            List<WikipediaApp.WikipediaEntry> entries = this.getEntries();
            Collections.sort(entries);
            this.publish(entries.toArray(new WikipediaApp.WikipediaEntry[entries.size()]));
            for (List<WikipediaApp.WikipediaEntry> chunk : WikipediaApp.partitionList(entries, this.wikipediaStatusUpdateChunkSize.get())) {
                WikipediaApp.updateWIWOSMStatus(chunk.get((int)0).wikipediaLang, chunk);
            }
            return null;
        }

        @Override
        protected void process(List<WikipediaApp.WikipediaEntry> chunks) {
            WikipediaToggleDialog.this.model.clear();
            for (WikipediaApp.WikipediaEntry i : chunks) {
                WikipediaToggleDialog.this.model.addElement(i);
            }
            WikipediaToggleDialog.this.updateTitle();
            WikipediaToggleDialog.this.updateWikipediaArticles();
        }
    }

    class WikipediaLoadCoordinatesAction
    extends AbstractAction {
        private final boolean wikidata;

        public WikipediaLoadCoordinatesAction(boolean wikidata) {
            super(wikidata ? I18n.tr((String)"Wikidata", (Object[])new Object[0]) : I18n.tr((String)"Coordinates", (Object[])new Object[0]));
            this.wikidata = wikidata;
            new ImageProvider("dialogs", wikidata ? "wikidata" : "wikipedia").getResource().attachImageIcon((AbstractAction)this, true);
            this.putValue("ShortDescription", wikidata ? I18n.tr((String)"Fetches all coordinates from Wikidata in the current view", (Object[])new Object[0]) : I18n.tr((String)"Fetches all coordinates from Wikipedia in the current view", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                final LatLon min = Main.map.mapView.getLatLon(0, Main.map.mapView.getHeight());
                final LatLon max = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), 0);
                WikipediaToggleDialog.this.titleContext = I18n.tr((String)"coordinates", (Object[])new Object[0]);
                WikipediaToggleDialog.this.updateTitle();
                new UpdateWikipediaArticlesSwingWorker(){

                    @Override
                    List<WikipediaApp.WikipediaEntry> getEntries() {
                        return WikipediaApp.getEntriesFromCoordinates(WikipediaLoadCoordinatesAction.this.wikidata ? "wikidata" : wikipediaLang.get(), min, max);
                    }
                }.execute();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

