/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class WikipediaCopyTemplate {
    private static final List<CoordCopyTemplateEntry> DEFAULT_TEMPLATES = Arrays.asList(new CoordCopyTemplateEntry("{{Coordinate}}", "wikipedia-coordinate", "{{Coordinate|NS={lat}|EW={lon}|type=landmark|region=}}"), new CoordCopyTemplateEntry("{{Coord}}", "wikipedia-coord", "{{Coord|{lat}|{lon}}}"), new CoordCopyTemplateEntry("{{Location dec}}", "wikipedia-location-dec", "{{Location dec|{lat}|{lon}}}"), new CoordCopyTemplateEntry("{{Object location dec}}", "wikipedia-object-location-dec", "{{Object location dec|{lat}|{lon}}}"));
    private static final List<CoordCopyTemplateEntry> TEMPLATE_ENTRIES = Main.pref.getListOfStructs("wikipedia.copytemplates", DEFAULT_TEMPLATES, CoordCopyTemplateEntry.class);

    public WikipediaCopyTemplate() {
        JosmAction previous = Main.main.menu.copyCoordinates;
        for (CoordCopyTemplateEntry templateEntry : TEMPLATE_ENTRIES) {
            CoordCopyTemplate t = new CoordCopyTemplate(templateEntry);
            JMenuItem menu = MainMenu.addAfter((JMenu)Main.main.menu.editMenu, (JosmAction)t, (boolean)false, (JosmAction)previous);
            menu.setToolTipText(I18n.tr((String)"Copies the {0} template to the system clipboard instantiated with the coordinates of the first selected node", (Object[])new Object[]{templateEntry.name}));
            previous = t;
        }
    }

    private static class CoordCopyTemplate
    extends JosmAction {
        protected final String pattern;

        public CoordCopyTemplate(CoordCopyTemplateEntry entry) {
            this(I18n.tr((String)"Copy {0} template", (Object[])new Object[]{entry.name}), entry.id, entry.pattern);
        }

        public CoordCopyTemplate(String name, String toolbarId, String pattern) {
            super(name, "dialogs/wikipedia", null, null, true, toolbarId, true);
            this.pattern = pattern;
        }

        public void actionPerformed(ActionEvent e) {
            Node node = this.getSelectedNode();
            if (node == null) {
                return;
            }
            Utils.copyToClipboard((String)this.pattern.replace("{lat}", Double.toString(node.getCoor().lat())).replace("{lon}", Double.toString(node.getCoor().lon())));
        }

        protected void updateEnabledState() {
            this.setEnabled(this.getSelectedNode() != null);
        }

        protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
            this.updateEnabledState();
        }

        protected Node getSelectedNode() {
            DataSet ds = this.getLayerManager().getEditDataSet();
            if (ds == null || ds.getSelected() == null) {
                return null;
            }
            SubclassFilteredCollection nodes = Utils.filteredCollection((Collection)ds.getSelected(), Node.class);
            return nodes.isEmpty() ? null : (Node)nodes.iterator().next();
        }
    }

    public static class CoordCopyTemplateEntry {
        @Preferences.pref
        public String name;
        @Preferences.pref
        public String id;
        @Preferences.pref
        public String pattern;

        public CoordCopyTemplateEntry() {
        }

        public CoordCopyTemplateEntry(String name, String id, String pattern) {
            this.name = name;
            this.id = id;
            this.pattern = pattern;
        }
    }
}

