/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

public enum DigitalBase10SizeUnit {
    BITS("b", "bit"){

        @Override
        public long convert(long l, DigitalBase10SizeUnit digitalBase10SizeUnit) {
            return digitalBase10SizeUnit.toBytes(l);
        }

        @Override
        public long toBits(long l) {
            return l;
        }

        @Override
        public long toBytes(long l) {
            return l / 1000L;
        }

        @Override
        public long toGigabytes(long l) {
            return l / 1000000000000L;
        }

        @Override
        public long toKilobytes(long l) {
            return l / 1000000L;
        }

        @Override
        public long toMegabytes(long l) {
            return l / 1000000000L;
        }

        @Override
        public long toTerabytes(long l) {
            return l / 1000000000000000L;
        }
    }
    ,
    BYTES("B", "byte"){

        @Override
        public long convert(long l, DigitalBase10SizeUnit digitalBase10SizeUnit) {
            return digitalBase10SizeUnit.toBytes(l);
        }

        @Override
        public long toBits(long l) {
            return DigitalBase10SizeUnit.x(l, 8L, 9223372036854775L);
        }

        @Override
        public long toBytes(long l) {
            return l;
        }

        @Override
        public long toGigabytes(long l) {
            return l / 1000000000L;
        }

        @Override
        public long toKilobytes(long l) {
            return l / 1000L;
        }

        @Override
        public long toMegabytes(long l) {
            return l / 1000000L;
        }

        @Override
        public long toTerabytes(long l) {
            return l / 1000000000000L;
        }
    }
    ,
    GIGABYTES("gigabyte", "G"){

        @Override
        public long convert(long l, DigitalBase10SizeUnit digitalBase10SizeUnit) {
            return digitalBase10SizeUnit.toGigabytes(l);
        }

        @Override
        public long toBits(long l) {
            return DigitalBase10SizeUnit.x(l, 1000000000L, 9223372036854L);
        }

        @Override
        public long toBytes(long l) {
            return DigitalBase10SizeUnit.x(l, 1000000000L, 9223372036L);
        }

        @Override
        public long toGigabytes(long l) {
            return l;
        }

        @Override
        public long toKilobytes(long l) {
            return DigitalBase10SizeUnit.x(l, 1000000L, 9223372036854L);
        }

        @Override
        public long toMegabytes(long l) {
            return DigitalBase10SizeUnit.x(l, 1000L, 9223372036854775L);
        }

        @Override
        public long toTerabytes(long l) {
            return l / 1000L;
        }
    }
    ,
    KILOBYTES("kilobytes", "K"){

        @Override
        public long convert(long l, DigitalBase10SizeUnit digitalBase10SizeUnit) {
            return digitalBase10SizeUnit.toKilobytes(l);
        }

        @Override
        public long toBits(long l) {
            return DigitalBase10SizeUnit.x(l, 1000L, 9223372036854775L);
        }

        @Override
        public long toBytes(long l) {
            return DigitalBase10SizeUnit.x(l, 1000L, 9223372036854775L);
        }

        @Override
        public long toGigabytes(long l) {
            return l / 1000000L;
        }

        @Override
        public long toKilobytes(long l) {
            return l;
        }

        @Override
        public long toMegabytes(long l) {
            return l / 1000L;
        }

        @Override
        public long toTerabytes(long l) {
            return l / 1000000000L;
        }
    }
    ,
    MEGABYTES("megabytes", "M"){

        @Override
        public long convert(long l, DigitalBase10SizeUnit digitalBase10SizeUnit) {
            return digitalBase10SizeUnit.toMegabytes(l);
        }

        @Override
        public long toBits(long l) {
            return DigitalBase10SizeUnit.x(l, 1000000L, 9223372036854775L);
        }

        @Override
        public long toBytes(long l) {
            return DigitalBase10SizeUnit.x(l, 1000000L, 9223372036854L);
        }

        @Override
        public long toGigabytes(long l) {
            return l / 1000L;
        }

        @Override
        public long toKilobytes(long l) {
            return DigitalBase10SizeUnit.x(l, 1000L, 9223372036854775L);
        }

        @Override
        public long toMegabytes(long l) {
            return l;
        }

        @Override
        public long toTerabytes(long l) {
            return l / 1000000L;
        }
    }
    ,
    TERABYTES("terabyte", "T"){

        @Override
        public long convert(long l, DigitalBase10SizeUnit digitalBase10SizeUnit) {
            return digitalBase10SizeUnit.toTerabytes(l);
        }

        @Override
        public long toBits(long l) {
            return DigitalBase10SizeUnit.x(l, 1000000000000L, 9223372036L);
        }

        @Override
        public long toBytes(long l) {
            return DigitalBase10SizeUnit.x(l, 1000000000000L, 0x8CBCCCL);
        }

        @Override
        public long toGigabytes(long l) {
            return DigitalBase10SizeUnit.x(l, 1000L, 9223372036854775L);
        }

        @Override
        public long toKilobytes(long l) {
            return DigitalBase10SizeUnit.x(l, 1000000000L, 9223372036L);
        }

        @Override
        public long toMegabytes(long l) {
            return DigitalBase10SizeUnit.x(l, 1000000L, 9223372036854L);
        }

        @Override
        public long toTerabytes(long l) {
            return l;
        }
    };

    private static final long MULB = 8L;
    private static final long MULK = 1000L;
    private static final long K0 = 1L;
    private static final long K1 = 1000L;
    private static final long K2 = 1000000L;
    private static final long K3 = 1000000000L;
    private static final long K4 = 1000000000000L;
    private static final long K5 = 1000000000000000L;
    private final String name;
    private final String symbol;

    private static long x(long l, long l2, long l3) {
        if (l > l3) {
            return Long.MAX_VALUE;
        }
        if (l < -l3) {
            return Long.MIN_VALUE;
        }
        return l * l2;
    }

    private DigitalBase10SizeUnit(String string2, String string3) {
        this.name = string2;
        this.symbol = string3;
    }

    protected abstract long convert(long var1, DigitalBase10SizeUnit var3);

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public abstract long toBits(long var1);

    public abstract long toBytes(long var1);

    public abstract long toGigabytes(long var1);

    public abstract long toKilobytes(long var1);

    public abstract long toMegabytes(long var1);

    public abstract long toTerabytes(long var1);
}

