/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pcx;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.PixelDensity;
import org.apache.commons.imaging.common.BinaryOutputStream;
import org.apache.commons.imaging.palette.PaletteFactory;
import org.apache.commons.imaging.palette.SimplePalette;

class PcxWriter {
    private int encoding;
    private int bitDepth = -1;
    private PixelDensity pixelDensity;

    public PcxWriter(Map<String, Object> params) throws ImageWriteException {
        Object value;
        Map<String, Object> map = params = params == null ? new HashMap<String, Object>() : new HashMap<String, Object>(params);
        if (params.containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        this.encoding = 1;
        if (params.containsKey("PCX_COMPRESSION") && (value = params.remove("PCX_COMPRESSION")) != null) {
            if (!(value instanceof Number)) {
                throw new ImageWriteException("Invalid compression parameter: " + value);
            }
            int compression = ((Number)value).intValue();
            if (compression == 0) {
                this.encoding = 0;
            }
        }
        if (params.containsKey("PCX_BIT_DEPTH") && (value = params.remove("PCX_BIT_DEPTH")) != null) {
            if (!(value instanceof Number)) {
                throw new ImageWriteException("Invalid bit depth parameter: " + value);
            }
            this.bitDepth = ((Number)value).intValue();
        }
        if (params.containsKey("PIXEL_DENSITY") && (value = params.remove("PIXEL_DENSITY")) != null) {
            if (!(value instanceof PixelDensity)) {
                throw new ImageWriteException("Invalid pixel density parameter");
            }
            this.pixelDensity = (PixelDensity)value;
        }
        if (this.pixelDensity == null) {
            this.pixelDensity = PixelDensity.createFromPixelsPerInch(72.0, 72.0);
        }
        if (!params.isEmpty()) {
            String firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
    }

    private void writeScanLine(BinaryOutputStream bos, byte[] scanline) throws IOException, ImageWriteException {
        if (this.encoding == 0) {
            bos.write(scanline);
        } else if (this.encoding == 1) {
            int previousByte = -1;
            int repeatCount = 0;
            for (byte element : scanline) {
                if ((element & 0xFF) == previousByte && repeatCount < 63) {
                    ++repeatCount;
                    continue;
                }
                if (repeatCount > 0) {
                    if (repeatCount == 1 && (previousByte & 0xC0) != 192) {
                        bos.write(previousByte);
                    } else {
                        bos.write(0xC0 | repeatCount);
                        bos.write(previousByte);
                    }
                }
                previousByte = 0xFF & element;
                repeatCount = 1;
            }
            if (repeatCount > 0) {
                if (repeatCount == 1 && (previousByte & 0xC0) != 192) {
                    bos.write(previousByte);
                } else {
                    bos.write(0xC0 | repeatCount);
                    bos.write(previousByte);
                }
            }
        } else {
            throw new ImageWriteException("Invalid PCX encoding " + this.encoding);
        }
    }

    public void writeImage(BufferedImage src, OutputStream os) throws ImageWriteException, IOException {
        PaletteFactory paletteFactory = new PaletteFactory();
        SimplePalette palette = paletteFactory.makeExactRgbPaletteSimple(src, 256);
        BinaryOutputStream bos = new BinaryOutputStream(os, ByteOrder.LITTLE_ENDIAN);
        if (palette == null || this.bitDepth == 24 || this.bitDepth == 32) {
            if (this.bitDepth == 32) {
                this.write32BppPCX(src, bos);
            } else {
                this.write24BppPCX(src, bos);
            }
        } else if (palette.length() > 16 || this.bitDepth == 8) {
            this.write256ColorPCX(src, palette, bos);
        } else if (palette.length() > 2 || this.bitDepth == 4) {
            this.write16ColorPCX(src, palette, bos);
        } else {
            int rgb;
            boolean onlyBlackAndWhite = true;
            if (palette.length() >= 1 && (rgb = palette.getEntry(0)) != 0 && rgb != 0xFFFFFF) {
                onlyBlackAndWhite = false;
            }
            if (palette.length() == 2 && (rgb = palette.getEntry(1)) != 0 && rgb != 0xFFFFFF) {
                onlyBlackAndWhite = false;
            }
            if (onlyBlackAndWhite) {
                this.writeBlackAndWhitePCX(src, bos);
            } else {
                this.write16ColorPCX(src, palette, bos);
            }
        }
    }

    private void write32BppPCX(BufferedImage src, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = src.getWidth() % 2 == 0 ? src.getWidth() : src.getWidth() + 1;
        bos.write(10);
        bos.write(5);
        bos.write(this.encoding);
        bos.write(32);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(new byte[48]);
        bos.write(0);
        bos.write(1);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        int[] rgbs = new int[src.getWidth()];
        byte[] rgbBytes = new byte[4 * bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            src.getRGB(0, y, src.getWidth(), 1, rgbs, 0, src.getWidth());
            for (int x = 0; x < rgbs.length; ++x) {
                rgbBytes[4 * x + 0] = (byte)(rgbs[x] & 0xFF);
                rgbBytes[4 * x + 1] = (byte)(rgbs[x] >> 8 & 0xFF);
                rgbBytes[4 * x + 2] = (byte)(rgbs[x] >> 16 & 0xFF);
                rgbBytes[4 * x + 3] = 0;
            }
            this.writeScanLine(bos, rgbBytes);
        }
    }

    private void write24BppPCX(BufferedImage src, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = src.getWidth() % 2 == 0 ? src.getWidth() : src.getWidth() + 1;
        bos.write(10);
        bos.write(5);
        bos.write(this.encoding);
        bos.write(8);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(new byte[48]);
        bos.write(0);
        bos.write(3);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        int[] rgbs = new int[src.getWidth()];
        byte[] rgbBytes = new byte[3 * bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            src.getRGB(0, y, src.getWidth(), 1, rgbs, 0, src.getWidth());
            for (int x = 0; x < rgbs.length; ++x) {
                rgbBytes[x] = (byte)(rgbs[x] >> 16 & 0xFF);
                rgbBytes[bytesPerLine + x] = (byte)(rgbs[x] >> 8 & 0xFF);
                rgbBytes[2 * bytesPerLine + x] = (byte)(rgbs[x] & 0xFF);
            }
            this.writeScanLine(bos, rgbBytes);
        }
    }

    private void writeBlackAndWhitePCX(BufferedImage src, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = (src.getWidth() + 7) / 8;
        if (bytesPerLine % 2 != 0) {
            ++bytesPerLine;
        }
        bos.write(10);
        bos.write(3);
        bos.write(this.encoding);
        bos.write(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(new byte[48]);
        bos.write(0);
        bos.write(1);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        byte[] row = new byte[bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            Arrays.fill(row, (byte)0);
            for (int x = 0; x < src.getWidth(); ++x) {
                int bit;
                int rgb = 0xFFFFFF & src.getRGB(x, y);
                if (rgb == 0) {
                    bit = 0;
                } else if (rgb == 0xFFFFFF) {
                    bit = 1;
                } else {
                    throw new ImageWriteException("Pixel neither black nor white");
                }
                int n = x / 8;
                row[n] = (byte)(row[n] | bit << 7 - x % 8);
            }
            this.writeScanLine(bos, row);
        }
    }

    private void write16ColorPCX(BufferedImage src, SimplePalette palette, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = (src.getWidth() + 1) / 2;
        if (bytesPerLine % 2 != 0) {
            ++bytesPerLine;
        }
        byte[] palette16 = new byte[48];
        for (int i = 0; i < 16; ++i) {
            int rgb = i < palette.length() ? palette.getEntry(i) : 0;
            palette16[3 * i + 0] = (byte)(0xFF & rgb >> 16);
            palette16[3 * i + 1] = (byte)(0xFF & rgb >> 8);
            palette16[3 * i + 2] = (byte)(0xFF & rgb);
        }
        bos.write(10);
        bos.write(5);
        bos.write(this.encoding);
        bos.write(4);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(palette16);
        bos.write(0);
        bos.write(1);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        byte[] indeces = new byte[bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            Arrays.fill(indeces, (byte)0);
            for (int x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                int index = palette.getPaletteIndex(0xFFFFFF & argb);
                int n = x / 2;
                indeces[n] = (byte)(indeces[n] | index << 4 * (1 - x % 2));
            }
            this.writeScanLine(bos, indeces);
        }
    }

    private void write256ColorPCX(BufferedImage src, SimplePalette palette, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = src.getWidth() % 2 == 0 ? src.getWidth() : src.getWidth() + 1;
        bos.write(10);
        bos.write(5);
        bos.write(this.encoding);
        bos.write(8);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(new byte[48]);
        bos.write(0);
        bos.write(1);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        byte[] indeces = new byte[bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                int index = palette.getPaletteIndex(0xFFFFFF & argb);
                indeces[x] = (byte)index;
            }
            this.writeScanLine(bos, indeces);
        }
        bos.write(12);
        for (int i = 0; i < 256; ++i) {
            int rgb = i < palette.length() ? palette.getEntry(i) : 0;
            bos.write(rgb >> 16 & 0xFF);
            bos.write(rgb >> 8 & 0xFF);
            bos.write(rgb & 0xFF);
        }
    }
}

