/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.io.download;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.ExecutorService;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryURL;

public class MapillaryImageInfoDownloadThread
extends Thread {
    private final Bounds bounds;
    private final int page;
    private final ExecutorService ex;

    public MapillaryImageInfoDownloadThread(ExecutorService ex, Bounds bounds, int page) {
        this.bounds = bounds;
        this.page = page;
        this.ex = ex;
    }

    @Override
    public void run() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(MapillaryURL.searchImageInfoURL(this.bounds, this.page, null).openStream(), "UTF-8"));
             JsonReader reader = Json.createReader((Reader)br);){
            JsonObject jsonObj = reader.readObject();
            if (!jsonObj.getBoolean("more")) {
                this.ex.shutdown();
            }
            JsonArray jsonArr = jsonObj.getJsonArray("ims");
            for (int i = 0; i < jsonArr.size(); ++i) {
                JsonObject data = jsonArr.getJsonObject(i);
                String key = data.getString("key");
                for (MapillaryAbstractImage image : MapillaryLayer.getInstance().getData().getImages()) {
                    if (!(image instanceof MapillaryImage) || !((MapillaryImage)image).getKey().equals(key) || ((MapillaryImage)image).getUser() != null) continue;
                    ((MapillaryImage)image).setUser(data.getString("user"));
                    ((MapillaryImage)image).setCapturedAt(data.getJsonNumber("captured_at").longValue());
                }
            }
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
    }
}

