/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.history.commands;

import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.history.commands.MapillaryCommand;
import org.openstreetmap.josm.plugins.mapillary.history.commands.MapillaryExecutableCommand;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;

public class CommandJoin
extends MapillaryExecutableCommand {
    private final MapillaryAbstractImage a;
    private final MapillaryAbstractImage b;

    public CommandJoin(List<MapillaryAbstractImage> images) {
        super(new ConcurrentSkipListSet<MapillaryAbstractImage>(images));
        this.a = images.get(0);
        this.b = images.get(1);
        if (images.size() != 2) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        MapillaryUtils.unjoin(this.a, this.b);
    }

    @Override
    public void redo() {
        MapillaryUtils.join(this.a, this.b);
    }

    @Override
    public void sum(MapillaryCommand command) {
    }

    @Override
    public String toString() {
        return I18n.tr((String)"2 images joined", (Object[])new Object[0]);
    }
}

