/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatDg100;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatImportDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class GlobalsatPlugin
extends Plugin {
    private static GlobalsatDg100 device = null;
    GlobalsatImportAction importAction;

    public static GlobalsatDg100 dg100() {
        return device;
    }

    public static void setPortIdent(CommPortIdentifier port) {
        if (device != null) {
            device.disconnect();
        }
        device = new GlobalsatDg100(port);
    }

    public GlobalsatPlugin(PluginInformation info) {
        boolean error;
        block3: {
            super(info);
            error = false;
            try {
                CommPortIdentifier.getPortIdentifiers();
            }
            catch (UnsatisfiedLinkError e) {
                error = true;
                String msg = I18n.tr((String)"Cannot load library rxtxSerial. If you need support to install it try Globalsat homepage at http://www.raphael-mack.de/josm-globalsat-gpx-import-plugin/", (Object[])new Object[0]);
                Main.error((String)msg);
                if (GraphicsEnvironment.isHeadless()) break block3;
                JOptionPane.showMessageDialog(Main.parent, "<html>" + msg + "</html>");
            }
        }
        if (!error) {
            this.importAction = new GlobalsatImportAction();
            Main.main.menu.toolsMenu.add((Action)((Object)this.importAction));
        }
    }

    class GlobalsatImportAction
    extends JosmAction {
        public GlobalsatImportAction() {
            super(I18n.tr((String)"Globalsat Import", (Object[])new Object[0]), "globalsatImport", I18n.tr((String)"Import Data from Globalsat Datalogger DG100 into GPX layer.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"menu:globalsatimport", (String)I18n.tr((String)"Menu: {0}", (Object[])new Object[]{I18n.tr((String)"Globalsat Import", (Object[])new Object[0])}), (int)71, (int)5008), false);
        }

        public void actionPerformed(ActionEvent e) {
            GlobalsatImportDialog dialog = new GlobalsatImportDialog();
            JOptionPane pane = new JOptionPane(dialog, -1, 2);
            JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Import", (Object[])new Object[0]));
            dlg.setVisible(true);
            if ((Integer)pane.getValue() == 0) {
                GlobalsatPlugin.setPortIdent(dialog.getPort());
                ImportTask task = new ImportTask(dialog.deleteFilesAfterDownload());
                Main.worker.execute((Runnable)((Object)task));
            }
            dlg.dispose();
        }
    }

    private static class ImportTask
    extends PleaseWaitRunnable {
        public GpxData data;
        public Exception eee;
        private boolean deleteAfter;

        public ImportTask(boolean delete) {
            super(I18n.tr((String)"Importing data from device.", (Object[])new Object[0]));
            this.deleteAfter = delete;
        }

        public void realRun() throws IOException, SAXException {
            this.progressMonitor.subTask(I18n.tr((String)"Importing data from DG100...", (Object[])new Object[0]));
            try {
                this.data = GlobalsatPlugin.dg100().readData(this.progressMonitor.createSubTaskMonitor(-1, true));
            }
            catch (Exception e) {
                this.eee = e;
            }
        }

        protected void finish() {
            if (this.deleteAfter && !GlobalsatPlugin.dg100().isCanceled()) {
                Main.pref.put("globalsat.deleteAfterDownload", true);
                try {
                    GlobalsatPlugin.dg100().deleteData();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error deleting data.", (Object[])new Object[0]) + " " + ex.toString());
                }
            } else {
                Main.pref.put("globalsat.deleteAfterDownload", false);
            }
            if (this.data != null && this.data.hasTrackPoints()) {
                Main.getLayerManager().addLayer((Layer)new GpxLayer(this.data, I18n.tr((String)"imported data from {0}", (Object[])new Object[]{"DG 100"})));
                Main.map.repaint();
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data found on device.", (Object[])new Object[0]));
            }
            if (this.eee != null) {
                this.eee.printStackTrace();
                System.out.println(this.eee.getMessage());
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Connection failed.", (Object[])new Object[0]) + " (" + this.eee.toString() + ")");
            }
            GlobalsatPlugin.dg100().disconnect();
        }

        protected void cancel() {
            GlobalsatPlugin.dg100().cancel();
            GlobalsatPlugin.dg100().disconnect();
        }
    }
}

