/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import messages.Messages;
import panels.PanelCol;
import seamarks.SeaMark;
import smed.SmedAction;

public class PanelPat
extends JPanel {
    private SmedAction dlg;
    private SeaMark.Ent ent;
    public PanelCol panelCol;
    private ButtonGroup patButtons = new ButtonGroup();
    public JRadioButton noneButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/NoneButton.png")));
    public JRadioButton horizButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/HorizontalButton.png")));
    public JRadioButton vertButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/VerticalButton.png")));
    public JRadioButton diagButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/DiagonalButton.png")));
    public JRadioButton squareButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SquaredButton.png")));
    public JRadioButton borderButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/BorderButton.png")));
    public EnumMap<SeaMark.Pat, JRadioButton> patterns = new EnumMap(SeaMark.Pat.class);
    private ActionListener alPat = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Pat pat : PanelPat.this.patterns.keySet()) {
                JRadioButton button = PanelPat.this.patterns.get((Object)pat);
                if (button.isSelected()) {
                    SmedAction.panelMain.mark.setPattern(PanelPat.this.ent, pat);
                    button.setBorderPainted(true);
                    continue;
                }
                button.setBorderPainted(false);
            }
            switch (SmedAction.panelMain.mark.getPattern(PanelPat.this.ent)) {
                case NOPAT: {
                    PanelPat.this.panelCol.trimStack(1);
                    break;
                }
                case HSTRP: 
                case VSTRP: 
                case DIAG: {
                    break;
                }
                case SQUARED: {
                    PanelPat.this.panelCol.trimStack(4);
                    break;
                }
                case BORDER: 
                case CROSS: {
                    PanelPat.this.panelCol.trimStack(2);
                }
            }
        }
    };

    public PanelPat(SmedAction dia, SeaMark.Ent entity) {
        this.dlg = dia;
        this.ent = entity;
        this.setLayout(null);
        this.panelCol = new PanelCol(this.dlg, this.ent);
        this.panelCol.setBounds(new Rectangle(0, 0, 72, 160));
        this.add(this.panelCol);
        this.add(this.getPatButton(this.noneButton, 76, 0, 27, 27, "NoPat", SeaMark.Pat.NOPAT));
        this.add(this.getPatButton(this.horizButton, 76, 26, 27, 27, "HorizPat", SeaMark.Pat.HSTRP));
        this.add(this.getPatButton(this.vertButton, 76, 52, 27, 27, "VertPat", SeaMark.Pat.VSTRP));
        this.add(this.getPatButton(this.diagButton, 76, 78, 27, 27, "DiagPat", SeaMark.Pat.DIAG));
        this.add(this.getPatButton(this.squareButton, 76, 104, 27, 27, "SquarePat", SeaMark.Pat.SQUARED));
        this.add(this.getPatButton(this.borderButton, 76, 130, 27, 27, "BorderPat", SeaMark.Pat.BORDER));
    }

    public void syncPanel() {
        for (SeaMark.Pat pat : this.patterns.keySet()) {
            JRadioButton button = this.patterns.get((Object)pat);
            if (SmedAction.panelMain.mark.getPattern(this.ent) == pat) {
                button.setBorderPainted(true);
                continue;
            }
            button.setBorderPainted(false);
        }
        this.panelCol.syncPanel();
    }

    private JRadioButton getPatButton(JRadioButton button, int x, int y, int w, int h, String tip, SeaMark.Pat pat) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setToolTipText(Messages.getString(tip));
        button.addActionListener(this.alPat);
        this.patButtons.add(button);
        this.patterns.put(pat, button);
        return button;
    }
}

