/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.Component;
import java.util.Collection;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class GuiUtils {
    static final String PREF_OVERWRITE = "wikipedia.overwrite-tag";

    protected static boolean confirmOverwrite(final String key, final String newValue, final Collection<OsmPrimitive> primitives) {
        final TreeSet existingValues = new TreeSet(AlphanumComparator.getInstance());
        existingValues.addAll(Utils.transform(primitives, (Utils.Function)new Utils.Function<OsmPrimitive, String>(){

            public String apply(OsmPrimitive x) {
                return x.get(key);
            }
        }));
        existingValues.remove(newValue);
        existingValues.remove(null);
        if (existingValues.isEmpty()) {
            return true;
        }
        Boolean r = (Boolean)GuiHelper.runInEDTAndWaitAndReturn((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ConditionalOptionPaneUtil.showConfirmationDialog((String)GuiUtils.PREF_OVERWRITE, (Component)Main.parent, (Object)I18n.trn((String)"Overwrite ''{0}'' tag {1} from {2} with new value ''{3}''?", (String)"Overwrite ''{0}'' tags {1} from {2} with new value ''{3}''?", (long)existingValues.size(), (Object[])new Object[]{key, Utils.joinAsHtmlUnorderedList((Iterable)existingValues), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(primitives, 10), newValue}), (String)I18n.tr((String)"Overwrite key", (Object[])new Object[0]), (int)0, (int)3, (int)0);
            }
        });
        return Boolean.TRUE.equals(r);
    }
}

