/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.columbusCSV;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WayPoint;

public class WayPointHelper {
    public static final String HEIGHT_ATTRIBUTE = "ele";
    private static final double R = 6378135.0;

    private WayPointHelper() {
    }

    public static double getElevation(WayPoint wpt) {
        if (wpt != null) {
            if (!wpt.attr.containsKey(HEIGHT_ATTRIBUTE)) {
                return 0.0;
            }
            String height = wpt.getString(HEIGHT_ATTRIBUTE);
            try {
                return Double.parseDouble(height);
            }
            catch (NumberFormatException e) {
                Main.error((String)String.format("Cannot parse double from '%s': %s", height, e.getMessage()));
            }
        }
        return 0.0;
    }

    public static double getLonDist(WayPoint w1, WayPoint w2) {
        LatLon ll = new LatLon(w1.getCoor().lat(), w2.getCoor().lon());
        return w1.getCoor().greatCircleDistance(ll);
    }

    public static double getLatDist(WayPoint w1, WayPoint w2) {
        LatLon ll = new LatLon(w2.getCoor().lat(), w1.getCoor().lon());
        return w1.getCoor().greatCircleDistance(ll);
    }

    public static LatLon moveLatLon(LatLon src, double dlat, double dlon) {
        double lat1 = Math.toRadians(src.lat());
        double lon1 = Math.toRadians(src.lon());
        double dlonsin2 = Math.sin(dlon / 2.0 / 6378135.0);
        double dlatsin2 = Math.sin(dlat / 2.0 / 6378135.0);
        double dlatcos = Math.cos(lon1);
        double lon2rad = 2.0 * Math.asin(Math.sqrt(dlonsin2 * dlonsin2 / dlatcos / dlatcos)) + lon1;
        double lat2rad = 2.0 * Math.asin(dlatsin2) + lat1;
        double lon2 = Math.toDegrees(lon2rad);
        double lat2 = Math.toDegrees(lat2rad);
        return new LatLon(lat2, lon2);
    }

    public static List<WayPoint> downsampleWayPoints(List<WayPoint> origList, int targetSize) {
        if (origList == null) {
            return null;
        }
        if (targetSize <= 0) {
            throw new IllegalArgumentException("targetSize must be greater than zero");
        }
        int origSize = origList.size();
        if (origSize <= targetSize) {
            return origList;
        }
        int delta = (int)Math.max(Math.ceil(origSize / targetSize), 2.0);
        ArrayList<WayPoint> res = new ArrayList<WayPoint>(targetSize);
        for (int i = 0; i < origSize; i += delta) {
            res.add(origList.get(i));
        }
        return res;
    }
}

