/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WikipediaApp {
    public static Pattern WIKIDATA_PATTERN = Pattern.compile("Q\\d+");
    private static final DocumentBuilder DOCUMENT_BUILDER = WikipediaApp.newDocumentBuilder();
    private static final XPath X_PATH = XPathFactory.newInstance().newXPath();

    private WikipediaApp() {
    }

    static String getMediawikiLocale(Locale locale) {
        if (!locale.getCountry().isEmpty()) {
            return locale.getLanguage() + "-" + locale.getCountry().toLowerCase();
        }
        return locale.getLanguage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<WikipediaEntry> getEntriesFromCoordinates(String wikipediaLang, LatLon min, LatLon max) {
        try {
            String bbox = min.lon() + "," + min.lat() + "," + max.lon() + "," + max.lat();
            String url = "https://tools.wmflabs.org/wp-world/marks.php?bbox=" + bbox + "&LANG=" + wikipediaLang;
            XPathExpression xpathPlacemark = X_PATH.compile("//Placemark");
            XPathExpression xpathName = X_PATH.compile("name/text()");
            XPathExpression xpathCoord = X_PATH.compile("Point/coordinates/text()");
            XPathExpression xpathDescr = X_PATH.compile("description");
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document doc = DOCUMENT_BUILDER.parse(in);
                NodeList nodes = (NodeList)xpathPlacemark.evaluate(doc, XPathConstants.NODESET);
                ArrayList<WikipediaEntry> entries = new ArrayList<WikipediaEntry>(nodes.getLength());
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String[] coord = xpathCoord.evaluate(nodes.item(i)).split(",");
                    if (coord.length <= 2) continue;
                    String name = xpathName.evaluate(nodes.item(i));
                    String descr = xpathDescr.evaluate(nodes.item(i));
                    entries.add(new WikipediaEntry(name, descr, new LatLon(Double.parseDouble(coord[1]), Double.parseDouble(coord[0]))));
                }
                ArrayList<WikipediaEntry> arrayList = entries;
                return arrayList;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<WikipediaEntry> getEntriesFromCategory(String wikipediaLang, String category, int depth) {
        try {
            String url = "https://tools.wmflabs.org/cats-php/?lang=" + wikipediaLang + "&depth=" + depth + "&cat=" + Utils.encodeUrl((String)category);
            try (Scanner scanner = new Scanner(HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContentReader()).useDelimiter("\n");){
                ArrayList<WikipediaEntry> entries = new ArrayList<WikipediaEntry>();
                while (scanner.hasNext()) {
                    String article = scanner.next().trim().replace("_", " ");
                    entries.add(new WikipediaEntry(article, wikipediaLang, article));
                }
                ArrayList<WikipediaEntry> arrayList = entries;
                return arrayList;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static List<WikipediaEntry> getEntriesFromClipboard(final String wikipediaLang) {
        List<String> clipboardLines = Arrays.asList(Utils.getClipboardContent().split("[\\n\\r]+"));
        return new ArrayList<WikipediaEntry>(Utils.transform(clipboardLines, (Utils.Function)new Utils.Function<String, WikipediaEntry>(){

            public WikipediaEntry apply(String x) {
                return new WikipediaEntry(x, wikipediaLang, x);
            }
        }));
    }

    static void updateWIWOSMStatus(String wikipediaLang, Collection<WikipediaEntry> entries) {
        ArrayList<String> articleNames = new ArrayList<String>();
        for (WikipediaEntry i : entries) {
            articleNames.add(i.wikipediaArticle);
        }
        HashMap<String, Boolean> status = new HashMap<String, Boolean>();
        if (!articleNames.isEmpty()) {
            String url = "https://tools.wmflabs.org/wiwosm/osmjson/getGeoJSON.php?action=check&lang=" + wikipediaLang;
            try {
                String requestBody = "articles=" + Utils.encodeUrl((String)Utils.join((String)",", articleNames));
                try (Scanner scanner = new Scanner(HttpClient.create((URL)new URL(url), (String)"POST").setReasonForRequest("Wikipedia").setHeader("Content-Type", "application/x-www-form-urlencoded").setRequestBody(requestBody.getBytes(StandardCharsets.UTF_8)).connect().getContentReader()).useDelimiter("\n");){
                    while (scanner.hasNext()) {
                        String line = scanner.next();
                        String[] x = line.split("\t");
                        if (x.length == 2) {
                            status.put(x[0], "1".equals(x[1]));
                            continue;
                        }
                        Main.error((String)("Unknown element " + line));
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        for (WikipediaEntry i : entries) {
            i.setWiwosmStatus((Boolean)status.get(i.wikipediaArticle));
        }
    }

    static Collection<String> getWikipediaArticles(final String wikipediaLang, OsmPrimitive p) {
        Map tags = p.getKeys();
        return Utils.transform((Collection)Utils.filter(Arrays.asList(WikipediaLangArticle.parseTag("wikipedia", (String)tags.get("wikipedia")), WikipediaLangArticle.parseTag("wikipedia:" + wikipediaLang, (String)tags.get("wikipedia:" + wikipediaLang))), (Predicate)new Predicate<WikipediaLangArticle>(){

            public boolean evaluate(WikipediaLangArticle wp) {
                return wp != null && wikipediaLang.equals(wp.lang);
            }
        }), (Utils.Function)new Utils.Function<WikipediaLangArticle, String>(){

            public String apply(WikipediaLangArticle wp) {
                return wp.article;
            }
        });
    }

    static Map<String, String> getWikidataForArticles(String wikipediaLang, Collection<String> articles) {
        try {
            String url = "https://www.wikidata.org/w/api.php?action=wbgetentities&props=sitelinks&sites=" + wikipediaLang + "wiki" + "&sitefilter=" + wikipediaLang + "wiki" + "&format=xml" + "&titles=" + Utils.join((String)"|", (Collection)Utils.transform(articles, (Utils.Function)new Utils.Function<String, String>(){

                public String apply(String x) {
                    return Utils.encodeUrl((String)x);
                }
            }));
            TreeMap<String, String> r = new TreeMap<String, String>();
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = DOCUMENT_BUILDER.parse(in);
                NodeList nodes = (NodeList)X_PATH.compile("//entity").evaluate(xml, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String wikidata = (String)X_PATH.compile("./@id").evaluate(node, XPathConstants.STRING);
                    String wikipedia = (String)X_PATH.compile("./sitelinks/sitelink/@title").evaluate(node, XPathConstants.STRING);
                    r.put(wikipedia, wikidata);
                }
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getLabelForWikidata(String wikidataId, Locale locale, String ... preferredLanguage) {
        try {
            CheckParameterUtil.ensureThat((boolean)WIKIDATA_PATTERN.matcher(wikidataId).matches(), (String)"Invalid Wikidata ID given");
            String url = "https://www.wikidata.org/w/api.php?action=wbgetentities&props=labels&ids=" + wikidataId + "&format=xml";
            ArrayList<String> languages = new ArrayList<String>();
            if (locale != null) {
                languages.add(WikipediaApp.getMediawikiLocale(locale));
                languages.add(WikipediaApp.getMediawikiLocale(new Locale(locale.getLanguage())));
            }
            languages.addAll(Arrays.asList(preferredLanguage));
            languages.add("en");
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = DOCUMENT_BUILDER.parse(in);
                for (String language : languages) {
                    String label = (String)X_PATH.compile("//label[@language='" + language + "']/@value").evaluate(xml, XPathConstants.STRING);
                    if (label == null || label.isEmpty()) continue;
                    String string = label;
                    return string;
                }
                String fallBackLabel = (String)X_PATH.compile("//label/@value").evaluate(xml, XPathConstants.STRING);
                String string = fallBackLabel == null || fallBackLabel.isEmpty() ? null : fallBackLabel;
                return string;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static Collection<WikipediaLangArticle> getInterwikiArticles(String wikipediaLang, String article) {
        try {
            ArrayList<WikipediaLangArticle> r = new ArrayList<WikipediaLangArticle>();
            String url = "https://" + wikipediaLang + ".wikipedia.org/w/api.php" + "?action=query" + "&prop=langlinks" + "&titles=" + Utils.encodeUrl((String)article) + "&lllimit=500" + "&format=xml";
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = DOCUMENT_BUILDER.parse(in);
                NodeList nodes = (NodeList)X_PATH.compile("//ll").evaluate(xml, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String lang = nodes.item(i).getAttributes().getNamedItem("lang").getTextContent();
                    String name = nodes.item(i).getTextContent();
                    r.add(new WikipediaLangArticle(lang, name));
                }
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> List<List<T>> partitionList(final List<T> list, final int size) {
        return new AbstractList<List<T>>(){

            @Override
            public List<T> get(int index) {
                int fromIndex = index * size;
                int toIndex = Math.min(fromIndex + size, list.size());
                return list.subList(fromIndex, toIndex);
            }

            @Override
            public int size() {
                return (int)Math.ceil((float)list.size() / (float)size);
            }
        };
    }

    private static DocumentBuilder newDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Main.warn((String)"Cannot create DocumentBuilder");
            Main.warn((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static class WikipediaEntry
    implements Comparable<WikipediaEntry> {
        final String name;
        final String wikipediaLang;
        final String wikipediaArticle;
        final LatLon coordinate;
        private Boolean wiwosmStatus;

        public WikipediaEntry(String name, String description, LatLon coordinate) {
            this.name = name;
            this.coordinate = coordinate;
            WikipediaLangArticle wp = WikipediaLangArticle.parseFromUrl(this.getHrefFromDescription(description));
            if (wp == null) {
                Main.warn((String)("Could not extract Wikipedia tag from: " + this.getHrefFromDescription(description)));
            }
            this.wikipediaLang = wp == null ? null : wp.lang;
            this.wikipediaArticle = wp == null ? null : wp.article;
        }

        public WikipediaEntry(String name, String wikipediaLang, String wikipediaArticle) {
            this.name = name;
            this.wikipediaLang = wikipediaLang;
            this.wikipediaArticle = wikipediaArticle;
            this.coordinate = null;
        }

        protected final String getHrefFromDescription(String description) {
            if (description == null) {
                return null;
            }
            Matcher m = Pattern.compile(".*href=\"(.+?)\".*").matcher(description);
            if (m.matches()) {
                return m.group(1);
            }
            Main.warn((String)("Could not parse URL from: " + description));
            return null;
        }

        protected final Tag createWikipediaTag() {
            return new Tag("wikipedia", this.wikipediaLang + ":" + this.wikipediaArticle);
        }

        private void updateWiwosmStatus() {
            try {
                String url = "https://tools.wmflabs.org/wiwosm/osmjson/getGeoJSON.php?action=check&lang=" + this.wikipediaLang + "&article=" + Utils.encodeUrl((String)this.wikipediaArticle);
                try (Scanner scanner = new Scanner(HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContentReader());){
                    this.wiwosmStatus = scanner.hasNextInt() && scanner.nextInt() == 1;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void setWiwosmStatus(Boolean wiwosmStatus) {
            this.wiwosmStatus = wiwosmStatus;
        }

        public Boolean getWiwosmStatus() {
            return this.wiwosmStatus;
        }

        public String getBrowserUrl() {
            return "https://" + this.wikipediaLang + ".wikipedia.org/wiki/" + Utils.encodeUrl((String)this.wikipediaArticle.replace(" ", "_"));
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(WikipediaEntry o) {
            return this.name.compareTo(o.name);
        }
    }

    static class WikipediaLangArticle {
        final String lang;
        final String article;

        public WikipediaLangArticle(String lang, String article) {
            this.lang = lang;
            this.article = article;
        }

        public static WikipediaLangArticle parseFromUrl(String url) {
            if (url == null) {
                return null;
            }
            url = Utils.decodeUrl((String)url);
            Matcher m = Pattern.compile("(https?:)?//(\\w*)\\.wikipedia\\.org/wiki/(.*)").matcher(url);
            if (!m.matches()) {
                return null;
            }
            return new WikipediaLangArticle(m.group(2), m.group(3));
        }

        public static WikipediaLangArticle parseTag(String key, String value) {
            if (value == null) {
                return null;
            }
            if (value.startsWith("http")) {
                return WikipediaLangArticle.parseFromUrl(value);
            }
            if (value.contains(":")) {
                String[] item = Utils.decodeUrl((String)value).split(":", 2);
                String article = item[1].replace("_", " ");
                return new WikipediaLangArticle(item[0], article);
            }
            if (key.startsWith("wikipedia:")) {
                String[] item;
                String lang = key.split(":", 2)[1];
                String article = item[(item = Utils.decodeUrl((String)value).split(":", 2)).length == 2 ? 1 : 0].replace("_", " ");
                return new WikipediaLangArticle(lang, article);
            }
            return null;
        }

        public String toString() {
            return this.lang + ":" + this.article;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WikipediaLangArticle that = (WikipediaLangArticle)o;
            return Objects.equals(this.lang, that.lang) && Objects.equals(this.article, that.article);
        }

        public int hashCode() {
            return Objects.hash(this.lang, this.article);
        }
    }
}

