/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;
import org.wikipedia.WikipediaApp;

public class WikidataTagCellRenderer
extends DefaultTableCellRenderer {
    final Map<String, Future<String>> labelCache = new ConcurrentHashMap<String, Future<String>>();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        List<String> ids;
        if (column != 1 || !(value instanceof Map) || ((Map)value).size() != 1) {
            return null;
        }
        String key = table.getValueAt(row, 0).toString();
        if (!("wikidata".equals(key) || key != null && key.endsWith(":wikidata"))) {
            return null;
        }
        String id = ((Map)value).keySet().iterator().next().toString();
        JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (WikipediaApp.WIKIDATA_PATTERN.matcher(id).matches()) {
            return this.renderValues(Collections.singleton(id), table, component);
        }
        if (id.contains(";") && Utils.forAll(ids = Arrays.asList(id.split("\\s*;\\s*")), (Predicate)Predicates.stringMatchesPattern((Pattern)WikipediaApp.WIKIDATA_PATTERN))) {
            return this.renderValues(ids, table, component);
        }
        return null;
    }

    protected JLabel renderValues(Collection<String> ids, JTable table, JLabel component) {
        for (String id : ids) {
            if (this.labelCache.containsKey(id)) continue;
            this.labelCache.put(id, Main.worker.submit(new LabelLoader(id, table)));
        }
        ArrayList<String> texts = new ArrayList<String>(ids.size());
        for (String id : ids) {
            String label;
            if (!this.labelCache.get(id).isDone()) {
                return null;
            }
            try {
                label = this.labelCache.get(id).get();
            }
            catch (InterruptedException | ExecutionException e) {
                Main.warn((String)("Could not fetch Wikidata label for " + id));
                Main.warn((Throwable)e);
                return null;
            }
            if (label == null) {
                return null;
            }
            texts.add(Utils.escapeReservedCharactersHTML((String)id) + " <span color='gray'>" + Utils.escapeReservedCharactersHTML((String)label) + "</span>");
        }
        component.setText("<html>" + Utils.join((String)"; ", texts));
        component.setToolTipText("<html>" + Utils.joinAsHtmlUnorderedList(texts));
        return component;
    }

    static class LabelLoader
    implements Callable<String> {
        final String id;
        JTable table;

        public LabelLoader(String id, JTable table) {
            this.id = id;
            this.table = table;
        }

        @Override
        public String call() throws Exception {
            String label = WikipediaApp.getLabelForWikidata(this.id, LanguageInfo.getJOSMLocaleCode());
            this.table.repaint();
            this.table = null;
            return label;
        }
    }
}

