/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.measurement.MeasurementLayer;
import org.openstreetmap.josm.plugins.measurement.MeasurementPlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class MeasurementDialog
extends ToggleDialog
implements SelectionChangedListener,
DataSetListener,
NavigatableComponent.SoMChangeListener {
    private static final long serialVersionUID = 4708541586297950021L;
    private SideButton resetButton = new SideButton((Action)new AbstractAction(){
        {
            this.putValue("Name", I18n.tr((String)"Reset", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"select"));
            this.putValue("ShortDescription", I18n.tr((String)"Reset current measurement results and delete measurement path.", (Object[])new Object[0]));
            this.putValue("help", HelpUtil.ht((String)"/Dialog/Measurement#Reset"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MeasurementDialog.this.resetValues();
        }
    });
    protected JLabel pathLengthLabel;
    protected JLabel selectLengthLabel;
    protected JLabel selectAreaLabel;
    protected JLabel selectRadiusLabel;
    protected JLabel segAngleLabel;
    private DataSet ds;
    private Collection<Way> ways;
    private Collection<Node> nodes;

    public MeasurementDialog() {
        super(I18n.tr((String)"Measured values", (Object[])new Object[0]), "measure", I18n.tr((String)"Open the measurement window.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:measurement", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Measured values", (Object[])new Object[0])}), (int)85, (int)5009), 150);
        JPanel valuePanel = new JPanel(new GridLayout(0, 2));
        valuePanel.add(new JLabel(I18n.tr((String)"Path Length", (Object[])new Object[0])));
        this.pathLengthLabel = new JLabel(this.getDistText(0.0));
        valuePanel.add(this.pathLengthLabel);
        valuePanel.add(new JLabel(I18n.tr((String)"Selection Length", (Object[])new Object[0])));
        this.selectLengthLabel = new JLabel(this.getDistText(0.0));
        valuePanel.add(this.selectLengthLabel);
        valuePanel.add(new JLabel(I18n.tr((String)"Selection Area", (Object[])new Object[0])));
        this.selectAreaLabel = new JLabel(this.getAreaText(0.0));
        valuePanel.add(this.selectAreaLabel);
        valuePanel.add(new JLabel(I18n.tr((String)"Selection Radius", (Object[])new Object[0])));
        this.selectRadiusLabel = new JLabel(this.getRadiusText(0.0));
        valuePanel.add(this.selectRadiusLabel);
        JLabel angle = new JLabel(I18n.tr((String)"Angle", (Object[])new Object[0]));
        angle.setToolTipText(I18n.tr((String)"Angle between two selected Nodes", (Object[])new Object[0]));
        valuePanel.add(angle);
        this.segAngleLabel = new JLabel("- \u00b0");
        valuePanel.add(this.segAngleLabel);
        this.setPreferredSize(new Dimension(0, 92));
        this.createLayout(valuePanel, false, Arrays.asList(this.resetButton));
        DataSet.addSelectionListener((SelectionChangedListener)this);
        NavigatableComponent.addSoMChangeListener((NavigatableComponent.SoMChangeListener)this);
    }

    protected String getDistText(double v) {
        return NavigatableComponent.getSystemOfMeasurement().getDistText(v, (NumberFormat)new DecimalFormat("#0.000"), 0.001);
    }

    protected String getAreaText(double v) {
        return NavigatableComponent.getSystemOfMeasurement().getAreaText(v, (NumberFormat)new DecimalFormat("#0.000"), 0.001);
    }

    protected String getRadiusText(double v) {
        return NavigatableComponent.getSystemOfMeasurement().getDistText(v, (NumberFormat)new DecimalFormat("#0.000"), 0.001);
    }

    protected String getAngleText(double v) {
        return new DecimalFormat("#0.0").format(v) + " \u00b0";
    }

    public void resetValues() {
        MeasurementPlugin.getCurrentLayer().reset();
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        double length = 0.0;
        double segAngle = 0.0;
        double area = 0.0;
        double radius = 0.0;
        Node lastNode = null;
        this.ways = new SubclassFilteredCollection(newSelection, OsmPrimitive.wayPredicate);
        if (this.ways.isEmpty()) {
            this.nodes = new SubclassFilteredCollection(newSelection, OsmPrimitive.nodePredicate);
            for (Node n : this.nodes) {
                if (n.getCoor() == null) continue;
                if (lastNode == null) {
                    lastNode = n;
                    continue;
                }
                length += lastNode.getCoor().greatCircleDistance(n.getCoor());
                segAngle = MeasurementLayer.angleBetween(lastNode.getCoor(), n.getCoor());
                lastNode = n;
            }
        } else {
            this.nodes = null;
            for (Way w : this.ways) {
                Node lastN = null;
                double wayArea = 0.0;
                Double firstSegLength = null;
                boolean isCircle = true;
                for (Node n : w.getNodes()) {
                    if (lastN != null && lastN.getCoor() != null && n.getCoor() != null) {
                        double segLength = lastN.getCoor().greatCircleDistance(n.getCoor());
                        if (firstSegLength == null) {
                            firstSegLength = segLength;
                        }
                        if (isCircle && Math.abs(firstSegLength - segLength) > 1.0E-6) {
                            isCircle = false;
                        }
                        length += segLength;
                        wayArea += MeasurementLayer.calcX(n.getCoor()) * MeasurementLayer.calcY(lastN.getCoor()) - MeasurementLayer.calcY(n.getCoor()) * MeasurementLayer.calcX(lastN.getCoor());
                        segAngle = MeasurementLayer.angleBetween(lastN.getCoor(), n.getCoor());
                    }
                    lastN = n;
                }
                wayArea = lastN != null && lastN == w.getNodes().iterator().next() ? Math.abs(wayArea / 2.0) : 0.0;
                area += wayArea;
            }
            if (this.ways.size() == 1 && area > 0.0) {
                radius = length / (Math.PI * 2);
            }
        }
        final String lengthLabel = this.getDistText(length);
        final String angleLabel = this.getAngleText(segAngle);
        final String areaLabel = this.getAreaText(area);
        final String radiusLabel = this.getRadiusText(radius);
        GuiHelper.runInEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                MeasurementDialog.this.selectLengthLabel.setText(lengthLabel);
                MeasurementDialog.this.segAngleLabel.setText(angleLabel);
                MeasurementDialog.this.selectAreaLabel.setText(areaLabel);
                MeasurementDialog.this.selectRadiusLabel.setText(radiusLabel);
            }
        });
        DataSet currentDs = Main.main.getCurrentDataSet();
        if (this.ds != currentDs) {
            if (this.ds != null) {
                this.ds.removeDataSetListener((DataSetListener)this);
            }
            if (currentDs != null) {
                currentDs.addDataSetListener((DataSetListener)this);
            }
            this.ds = currentDs;
        }
    }

    public void destroy() {
        super.destroy();
        NavigatableComponent.removeSoMChangeListener((NavigatableComponent.SoMChangeListener)this);
        DataSet.removeSelectionListener((SelectionChangedListener)this);
        if (this.ds != null) {
            this.ds.removeDataSetListener((DataSetListener)this);
            this.ds = null;
        }
    }

    private boolean waysContain(Node n) {
        if (this.ways != null) {
            for (Way w : this.ways) {
                if (!w.containsNode(n)) continue;
                return true;
            }
        }
        return false;
    }

    public void nodeMoved(NodeMovedEvent event) {
        Node n = event.getNode();
        if (this.nodes != null && this.nodes.contains(n) || this.waysContain(n)) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void dataChanged(DataChangedEvent event) {
    }

    public void systemOfMeasurementChanged(String oldSoM, String newSoM) {
        this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
    }
}

