/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.grid;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.elevation.IVertexRenderer;
import org.openstreetmap.josm.plugins.elevation.grid.ElevationGridTile;
import org.openstreetmap.josm.plugins.elevation.grid.ElevationGridTileController;
import org.openstreetmap.josm.plugins.elevation.grid.ElevationGridTileLoader;
import org.openstreetmap.josm.plugins.elevation.grid.ElevationGridTileSource;
import org.openstreetmap.josm.plugins.elevation.grid.SimpleVertexRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ElevationGridLayer
extends Layer
implements TileLoaderListener {
    private static final int ELE_ZOOM_LEVEL = 13;
    private final IVertexRenderer vertexRenderer;
    private final MemoryTileCache tileCache;
    protected TileSource tileSource;
    protected ElevationGridTileLoader tileLoader;
    protected TileController tileController;
    private Bounds lastBounds;
    private TileSet tileSet;

    public ElevationGridLayer(String name) {
        super(name);
        this.setOpacity(0.8);
        this.setBackgroundLayer(true);
        this.vertexRenderer = new SimpleVertexRenderer();
        this.tileCache = new MemoryTileCache();
        this.tileCache.setCacheSize(500);
        this.tileSource = new ElevationGridTileSource(name);
        this.tileLoader = new ElevationGridTileLoader(this);
        this.tileController = new ElevationGridTileController(this.tileSource, (TileCache)this.tileCache, this, this.tileLoader);
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        boolean needsNewTileSet;
        boolean bl = needsNewTileSet = this.tileSet == null || this.lastBounds == null || !this.lastBounds.equals((Object)box);
        if (needsNewTileSet) {
            this.tileSet = new TileSet(box.getMin(), box.getMax(), 13);
            this.lastBounds = box;
            System.out.println("paint " + this.tileSet);
        }
        if (this.tileSet.insane()) {
            this.myDrawString(g, I18n.tr((String)"zoom in to load any tiles", (Object[])new Object[0]), 120, 120);
            return;
        }
        if (this.tileSet.tooLarge()) {
            this.myDrawString(g, I18n.tr((String)"zoom in to load more tiles", (Object[])new Object[0]), 120, 120);
            return;
        }
        if (this.tileSet.tooSmall()) {
            this.myDrawString(g, I18n.tr((String)"increase zoom level to see more detail", (Object[])new Object[0]), 120, 120);
            return;
        }
        for (int x = this.tileSet.x0; x <= this.tileSet.x1; ++x) {
            for (int y = this.tileSet.y0; y <= this.tileSet.y1; ++y) {
                Tile t = this.tileController.getTile(x, y, 13);
                if (t != null && t.isLoaded() && t instanceof ElevationGridTile) {
                    ((ElevationGridTile)t).paintTile(g, mv, this.vertexRenderer);
                    continue;
                }
                Point topLeft = mv.getPoint(new LatLon(this.tileSource.tileYToLat(y, 13), this.tileSource.tileXToLon(x, 13)));
                t.paint((Graphics)g, topLeft.x, topLeft.y);
            }
        }
    }

    public String getToolTipText() {
        return null;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Action[] getMenuEntries() {
        return null;
    }

    public void tileLoadingFinished(Tile tile, boolean success) {
        try {
            if (Main.map != null) {
                Main.map.repaint(100L);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace(System.err);
        }
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"elevation");
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public Object getInfoComponent() {
        return null;
    }

    void myDrawString(Graphics g, String text, int x, int y) {
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        g.drawString(text, x + 1, y + 1);
        g.setColor(oldColor);
        g.drawString(text, x, y);
    }

    private class TileSet {
        int x0;
        int x1;
        int y0;
        int y1;
        int tileMax = -1;

        public TileSet(LatLon topLeft, LatLon botRight, int zoom) {
            int tmp;
            if (zoom == 0) {
                return;
            }
            this.x0 = (int)ElevationGridLayer.this.tileSource.lonToTileX(topLeft.lon(), zoom);
            this.y0 = (int)ElevationGridLayer.this.tileSource.latToTileY(topLeft.lat(), zoom);
            this.x1 = (int)ElevationGridLayer.this.tileSource.lonToTileX(botRight.lon(), zoom);
            this.y1 = (int)ElevationGridLayer.this.tileSource.latToTileY(botRight.lat(), zoom);
            if (this.x0 > this.x1) {
                tmp = this.x0;
                this.x0 = this.x1;
                this.x1 = tmp;
            }
            if (this.y0 > this.y1) {
                tmp = this.y0;
                this.y0 = this.y1;
                this.y1 = tmp;
            }
            this.tileMax = (int)Math.pow(2.0, zoom);
            if (this.x0 < 0) {
                this.x0 = 0;
            }
            if (this.y0 < 0) {
                this.y0 = 0;
            }
            if (this.x1 > this.tileMax) {
                this.x1 = this.tileMax;
            }
            if (this.y1 > this.tileMax) {
                this.y1 = this.tileMax;
            }
        }

        int size() {
            int x_span = this.x1 - this.x0 + 1;
            int y_span = this.y1 - this.y0 + 1;
            return x_span * y_span;
        }

        public String toString() {
            return "TileSet [x0=" + this.x0 + ", x1=" + this.x1 + ", y0=" + this.y0 + ", y1=" + this.y1 + ", size()=" + this.size() + ", tilesSpanned()=" + this.tilesSpanned() + "]";
        }

        double tilesSpanned() {
            return Math.sqrt(1.0 * (double)this.size());
        }

        boolean tooSmall() {
            return this.tilesSpanned() < 1.0;
        }

        boolean tooLarge() {
            return this.tilesSpanned() > 50.0;
        }

        boolean insane() {
            return this.tilesSpanned() > 200.0;
        }
    }
}

