/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.I18n;

public class FixAddressesPreferences
extends DefaultTabPreferenceSetting {
    private static final String FIX_ADDRESSES_IGNORE_POST_CODE_KEY = "fixAddresses.ignorePostCode";
    private static final String FIX_ADDRESSES_SELECT_GUESSED_OBJECTS_KEY = "fixAddresses.selectGuessedObjects";
    private JCheckBox cbSelectGuessedObjects = new JCheckBox(I18n.tr((String)"Include objects used for guesses", (Object[])new Object[0]));
    private JCheckBox cbIgnorePostCode = new JCheckBox();

    private FixAddressesPreferences() {
        this.loadFromPrefs();
    }

    private void loadFromPrefs() {
        this.setSelectGuessedObjects(Main.pref.getBoolean(FIX_ADDRESSES_SELECT_GUESSED_OBJECTS_KEY, false));
        this.setIgnorePostCode(Main.pref.getBoolean(FIX_ADDRESSES_IGNORE_POST_CODE_KEY, false));
    }

    private void saveToPrefs() {
        Main.pref.put(FIX_ADDRESSES_SELECT_GUESSED_OBJECTS_KEY, this.isSelectGuessedObjects());
        Main.pref.put(FIX_ADDRESSES_IGNORE_POST_CODE_KEY, this.isIgnorePostCode());
    }

    public void addGui(PreferenceTabbedPane gui) {
        ButtonGroup fixAddrOptions = new ButtonGroup();
        fixAddrOptions.add(this.cbSelectGuessedObjects);
        fixAddrOptions.add(this.cbIgnorePostCode);
    }

    public boolean ok() {
        this.saveToPrefs();
        this.loadFromPrefs();
        return false;
    }

    public boolean isSelectGuessedObjects() {
        return this.cbSelectGuessedObjects.isSelected();
    }

    void setSelectGuessedObjects(boolean selectGuessedObjects) {
        this.cbSelectGuessedObjects.setSelected(selectGuessedObjects);
    }

    public boolean isIgnorePostCode() {
        return this.cbIgnorePostCode.isSelected();
    }

    public void setIgnorePostCode(boolean ignorePostCode) {
        this.cbIgnorePostCode.setSelected(ignorePostCode);
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new FixAddressesPreferences();
        }
    }
}

