/*
 * Decompiled with CFR 0.152.
 */
package iodb;

import iodb.ImageryOffsetBase;
import java.util.Map;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;

public class ImageryOffset
extends ImageryOffsetBase {
    private LatLon imageryPos;
    private String imagery;
    private int minZoom;
    private int maxZoom;

    public ImageryOffset(String imagery, LatLon imageryPos) {
        this.imageryPos = imageryPos;
        this.imagery = imagery;
        this.minZoom = 0;
        this.maxZoom = 30;
    }

    public void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public LatLon getImageryPos() {
        return this.imageryPos;
    }

    public String getImagery() {
        return this.imagery;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    @Override
    public void putServerParams(Map<String, String> map) {
        super.putServerParams(map);
        map.put("imagery", this.imagery);
        map.put("imlat", this.imageryPos.latToString(CoordinateFormat.DECIMAL_DEGREES));
        map.put("imlon", this.imageryPos.lonToString(CoordinateFormat.DECIMAL_DEGREES));
        if (this.minZoom > 0) {
            map.put("minzoom", String.valueOf(this.minZoom));
        }
        if (this.maxZoom < 30) {
            map.put("maxzoom", String.valueOf(this.maxZoom));
        }
    }

    @Override
    public String toString() {
        return "ImageryOffset{imageryPos=" + this.imageryPos + ", imagery=" + this.imagery + "position=" + this.position + ", date=" + this.date + ", author=" + this.author + ", description=" + this.description + ", abandonDate=" + this.abandonDate + '}';
    }
}

