/*
 * Decompiled with CFR 0.152.
 */
package iodb;

import iodb.ImageryOffsetTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.Destroyable;

public class ImageryOffsetWatcher
implements NavigatableComponent.ZoomChangeListener,
MapView.LayerChangeListener,
Destroyable {
    private static final double THRESHOLD = 1.0E-8;
    private static ImageryOffsetWatcher instance;
    private Map<Integer, ImageryLayerData> layers = new TreeMap<Integer, ImageryLayerData>();
    private List<OffsetStateListener> listeners = new ArrayList<OffsetStateListener>();
    private Timer time;
    private double maxDistance = Main.pref.getDouble("iodb.offset.radius", 15.0);
    private boolean offsetGood = true;

    private ImageryOffsetWatcher() {
        MapView.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        this.checkOffset();
        this.time = new Timer();
        this.time.schedule((TimerTask)new IntervalOffsetChecker(), 0L, 2000L);
    }

    public void destroy() {
        MapView.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
        MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
        this.time.cancel();
    }

    public static ImageryOffsetWatcher getInstance() {
        if (instance == null) {
            instance = new ImageryOffsetWatcher();
        }
        return instance;
    }

    public void register(OffsetStateListener listener) {
        this.listeners.add(listener);
        listener.offsetStateChanged(this.offsetGood);
    }

    public void unregister(OffsetStateListener listener) {
        this.listeners.remove(listener);
    }

    private void setOffsetGood(boolean good) {
        if (good != this.offsetGood) {
            for (OffsetStateListener listener : this.listeners) {
                listener.offsetStateChanged(good);
            }
        }
        this.offsetGood = good;
    }

    private synchronized void checkOffset() {
        if (this.maxDistance <= 0.0) {
            this.setOffsetGood(true);
            return;
        }
        ImageryLayer layer = ImageryOffsetTools.getTopImageryLayer();
        if (layer == null) {
            this.setOffsetGood(true);
            return;
        }
        LatLon center = ImageryOffsetTools.getMapCenter();
        Integer hash = layer.hashCode();
        ImageryLayerData data = this.layers.get(hash);
        if (data == null) {
            data = new ImageryLayerData();
            data.lastDx = layer.getDx();
            data.lastDy = layer.getDy();
            boolean r = false;
            if (Math.abs(data.lastDx) + Math.abs(data.lastDy) > 1.0E-8) {
                data.lastChecked = center;
                r = true;
            }
            this.layers.put(hash, data);
            this.setOffsetGood(r);
        } else if (Math.abs(data.lastDx - layer.getDx()) + Math.abs(data.lastDy - layer.getDy()) > 1.0E-8) {
            data.lastDx = layer.getDx();
            data.lastDy = layer.getDy();
            data.lastChecked = center;
            this.storeLayerOffset(layer);
            this.setOffsetGood(true);
        } else {
            this.setOffsetGood(data.lastChecked != null && center.greatCircleDistance(data.lastChecked) <= this.maxDistance * 1000.0);
        }
    }

    public void markGood() {
        ImageryLayer layer = ImageryOffsetTools.getTopImageryLayer();
        if (layer != null) {
            LatLon center = ImageryOffsetTools.getMapCenter();
            Integer hash = layer.hashCode();
            ImageryLayerData data = this.layers.get(hash);
            if (data == null) {
                data = new ImageryLayerData();
                data.lastDx = layer.getDx();
                data.lastDy = layer.getDy();
                data.lastChecked = center;
                this.layers.put(hash, data);
            } else {
                data.lastDx = layer.getDx();
                data.lastDy = layer.getDy();
                data.lastChecked = center;
            }
            this.storeLayerOffset(layer);
        }
        this.setOffsetGood(true);
    }

    public void zoomChanged() {
        this.checkOffset();
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        this.checkOffset();
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof ImageryLayer) {
            this.loadLayerOffset((ImageryLayer)newLayer);
        }
        this.checkOffset();
    }

    public void layerRemoved(Layer oldLayer) {
        this.checkOffset();
    }

    private void storeLayerOffset(ImageryLayer layer) {
        String id = ImageryOffsetTools.getImageryID(layer);
        if (!Main.pref.getBoolean("iodb.remember.offsets", true) || id == null) {
            return;
        }
        LinkedList<String> offsets = new LinkedList<String>(Main.pref.getCollection("iodb.stored.offsets"));
        Iterator iter = offsets.iterator();
        while (iter.hasNext()) {
            String[] offset = ((String)iter.next()).split(":");
            if (offset.length != 5 || !offset[0].equals(id)) continue;
            iter.remove();
        }
        LatLon center = ImageryOffsetTools.getMapCenter();
        offsets.add(id + ":" + center.lat() + ":" + center.lon() + ":" + layer.getDx() + ":" + layer.getDy());
        Main.pref.putCollection("iodb.stored.offsets", offsets);
    }

    private void loadLayerOffset(ImageryLayer layer) {
        String id = ImageryOffsetTools.getImageryID(layer);
        if (!Main.pref.getBoolean("iodb.remember.offsets", true) || id == null) {
            return;
        }
        Collection offsets = Main.pref.getCollection("iodb.stored.offsets");
        for (String offset : offsets) {
            String[] parts = offset.split(":");
            if (parts.length != 5 || !parts[0].equals(id)) continue;
            double[] dparts = new double[4];
            try {
                for (int i = 0; i < 4; ++i) {
                    dparts[i] = Double.parseDouble(parts[i + 1]);
                }
            }
            catch (Exception e) {
                continue;
            }
            LatLon lastPos = new LatLon(dparts[0], dparts[1]);
            if (!(lastPos.greatCircleDistance(ImageryOffsetTools.getMapCenter()) < Math.max(this.maxDistance, 3.0) * 1000.0)) continue;
            layer.setOffset(dparts[2], dparts[3]);
            return;
        }
    }

    public static interface OffsetStateListener {
        public void offsetStateChanged(boolean var1);
    }

    private class IntervalOffsetChecker
    extends TimerTask {
        private IntervalOffsetChecker() {
        }

        public void run() {
            ImageryOffsetWatcher.this.maxDistance = Main.pref.getDouble("iodb.offset.radius", 15.0);
            ImageryOffsetWatcher.this.checkOffset();
        }
    }

    private static class ImageryLayerData {
        public double lastDx = 0.0;
        public double lastDy = 0.0;
        public LatLon lastChecked;

        private ImageryLayerData() {
        }
    }
}

