/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.columbusCSV;

import java.io.File;
import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.columbusCSV.ColumbusCSVPreferences;
import org.openstreetmap.josm.plugins.columbusCSV.ColumbusCSVReader;
import org.openstreetmap.josm.tools.I18n;

public class ColumbusCSVImporter
extends FileImporter {
    public static final String COLUMBUS_FILE_EXT = "csv";
    public static final String COLUMBUS_FILE_EXT_DOT = ".csv";

    public ColumbusCSVImporter() {
        super(new ExtensionFileFilter(COLUMBUS_FILE_EXT, COLUMBUS_FILE_EXT, I18n.tr((String)"Columbus V-900 CSV Files", (Object[])new Object[0]) + " (*" + COLUMBUS_FILE_EXT_DOT + ")"));
    }

    public boolean acceptFile(File pathname) {
        try {
            boolean ok = super.acceptFile(pathname) && ColumbusCSVReader.isColumbusFile(pathname);
            return ok;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        String fn = file.getPath();
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        progressMonitor.beginTask(String.format(I18n.tr((String)"Importing CSV file ''%s''...", (Object[])new Object[0]), file.getName(), 4));
        progressMonitor.setTicksCount(1);
        if (fn.toLowerCase().endsWith(COLUMBUS_FILE_EXT_DOT)) {
            try {
                ColumbusCSVReader r = new ColumbusCSVReader();
                GpxData gpxData = r.transformColumbusCSV(fn);
                assert (gpxData != null);
                progressMonitor.setTicksCount(1);
                r.dropBufferLists();
                progressMonitor.setTicksCount(2);
                GpxLayer gpxLayer = new GpxLayer(gpxData, file.getName());
                assert (gpxLayer != null);
                Main.main.addLayer((Layer)gpxLayer);
                progressMonitor.setTicksCount(3);
                if (ColumbusCSVPreferences.zoomAfterImport()) {
                    AutoScaleAction action = new AutoScaleAction("data");
                    action.autoScale();
                }
                progressMonitor.setTicksCount(4);
                if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                    try {
                        MarkerLayer ml = new MarkerLayer(gpxData, I18n.tr((String)"Markers of ", (Object[])new Object[0]) + file.getName(), file, gpxLayer);
                        assert (ml != null);
                        assert (ml.data != null);
                        System.out.println("Layer: " + ml);
                        System.out.println("Data: " + ml.data != null);
                        System.out.println("Data size: " + ml.data.size());
                        Main.main.addLayer((Layer)ml);
                        if (ml.data.size() > 0) {
                        }
                        System.out.println("Warning: File contains no markers.");
                    }
                    catch (Exception exLayer) {
                        System.out.println(exLayer);
                        exLayer.printStackTrace(System.err);
                    }
                }
                System.out.println("Warning: Option 'marker.makeautomarkers' is not set; audio marker layer is not created.");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IllegalDataException((Throwable)e);
            }
            finally {
                progressMonitor.finishTask();
            }
        } else {
            throw new IOException(I18n.tr((String)String.format("Unsupported file extension (file '%s' does not end with '%s')!", file.getName(), COLUMBUS_FILE_EXT), (Object[])new Object[0]));
        }
    }
}

