/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import javax.swing.Icon;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.AbstractStyleFactory;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ColorMapEntryImpl;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.ColorReplacementImpl;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.Description;
import org.geotools.styling.Displacement;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.ExtensionSymbolizer;
import org.geotools.styling.Extent;
import org.geotools.styling.ExtentImpl;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.ExternalGraphicImpl;
import org.geotools.styling.ExternalMarkImpl;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeConstraintImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Fill;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Font;
import org.geotools.styling.FontImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.GraphicLegend;
import org.geotools.styling.Halo;
import org.geotools.styling.HaloImpl;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.ImageOutlineImpl;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LayerFeatureConstraints;
import org.geotools.styling.LayerFeatureConstraintsImpl;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LinePlacementImpl;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.LineSymbolizerImpl;
import org.geotools.styling.Mark;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedLayerImpl;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.NamedStyleImpl;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.PolygonSymbolizerImpl;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.RasterSymbolizerImpl;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.RemoteOWSImpl;
import org.geotools.styling.Rule;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.Stroke;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory2;
import org.geotools.styling.StyleFactoryImpl2;
import org.geotools.styling.StyleImpl;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.StyledLayerDescriptorImpl;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.TextSymbolizerImpl;
import org.geotools.styling.UserLayer;
import org.geotools.styling.UserLayerImpl;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.ColorReplacement;
import org.opengis.style.ContrastMethod;
import org.opengis.style.ExternalMark;
import org.opengis.style.GraphicFill;
import org.opengis.style.GraphicStroke;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.OverlapBehavior;
import org.opengis.style.SemanticType;
import org.opengis.style.StyleFactory;
import org.opengis.util.InternationalString;

public class StyleFactoryImpl
extends AbstractStyleFactory
implements StyleFactory2,
StyleFactory {
    private FilterFactory2 filterFactory;
    private StyleFactoryImpl2 delegate;

    public StyleFactoryImpl() {
        this(CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints()));
    }

    protected StyleFactoryImpl(FilterFactory2 factory) {
        this.filterFactory = factory;
        this.delegate = new StyleFactoryImpl2(this.filterFactory);
    }

    @Override
    public Style createStyle() {
        return new StyleImpl();
    }

    @Override
    public NamedStyle createNamedStyle() {
        return new NamedStyleImpl();
    }

    @Override
    public PointSymbolizer createPointSymbolizer() {
        return new PointSymbolizerImpl();
    }

    @Override
    public PointSymbolizer createPointSymbolizer(Graphic graphic, String geometryPropertyName) {
        PointSymbolizerImpl pSymb = new PointSymbolizerImpl();
        pSymb.setGeometryPropertyName(geometryPropertyName);
        pSymb.setGraphic((org.opengis.style.Graphic)graphic);
        return pSymb;
    }

    @Override
    public PolygonSymbolizer createPolygonSymbolizer() {
        return new PolygonSymbolizerImpl();
    }

    @Override
    public PolygonSymbolizer createPolygonSymbolizer(Stroke stroke, Fill fill, String geometryPropertyName) {
        PolygonSymbolizerImpl pSymb = new PolygonSymbolizerImpl();
        pSymb.setGeometryPropertyName(geometryPropertyName);
        pSymb.setStroke((org.opengis.style.Stroke)stroke);
        pSymb.setFill((org.opengis.style.Fill)fill);
        return pSymb;
    }

    @Override
    public LineSymbolizer createLineSymbolizer() {
        return new LineSymbolizerImpl();
    }

    @Override
    public LineSymbolizer createLineSymbolizer(Stroke stroke, String geometryPropertyName) {
        LineSymbolizerImpl lSymb = new LineSymbolizerImpl();
        lSymb.setGeometryPropertyName(geometryPropertyName);
        lSymb.setStroke((org.opengis.style.Stroke)stroke);
        return lSymb;
    }

    @Override
    public TextSymbolizer createTextSymbolizer() {
        return new TextSymbolizerImpl((FilterFactory)this.filterFactory);
    }

    @Override
    public TextSymbolizer createTextSymbolizer(Fill fill, Font[] fonts, Halo halo, Expression label, LabelPlacement labelPlacement, String geometryPropertyName) {
        TextSymbolizerImpl tSymb = new TextSymbolizerImpl((FilterFactory)this.filterFactory);
        tSymb.setFill((org.opengis.style.Fill)fill);
        tSymb.setFonts(fonts);
        tSymb.setGeometryPropertyName(geometryPropertyName);
        tSymb.setHalo((org.opengis.style.Halo)halo);
        tSymb.setLabel(label);
        tSymb.setPlacement(labelPlacement);
        return tSymb;
    }

    public TextSymbolizer2 createTextSymbolizer(Fill fill, Font[] fonts, Halo halo, Expression label, LabelPlacement labelPlacement, String geometryPropertyName, Graphic graphic) {
        TextSymbolizerImpl tSymb = new TextSymbolizerImpl((FilterFactory)this.filterFactory);
        tSymb.setFill((org.opengis.style.Fill)fill);
        tSymb.setFonts(fonts);
        tSymb.setGeometryPropertyName(geometryPropertyName);
        tSymb.setHalo((org.opengis.style.Halo)halo);
        tSymb.setLabel(label);
        tSymb.setPlacement(labelPlacement);
        tSymb.setGraphic(graphic);
        return tSymb;
    }

    public Extent createExtent(String name, String value) {
        ExtentImpl extent = new ExtentImpl();
        extent.setName(name);
        extent.setValue(value);
        return extent;
    }

    public FeatureTypeConstraint createFeatureTypeConstraint(String featureTypeName, Filter filter, Extent[] extents) {
        FeatureTypeConstraintImpl constraint = new FeatureTypeConstraintImpl();
        constraint.setFeatureTypeName(featureTypeName);
        constraint.setFilter(filter);
        constraint.setExtents(extents);
        return constraint;
    }

    public LayerFeatureConstraints createLayerFeatureConstraints(FeatureTypeConstraint[] featureTypeConstraints) {
        LayerFeatureConstraintsImpl constraints = new LayerFeatureConstraintsImpl();
        constraints.setFeatureTypeConstraints(featureTypeConstraints);
        return constraints;
    }

    @Override
    public FeatureTypeStyle createFeatureTypeStyle() {
        return new FeatureTypeStyleImpl();
    }

    @Override
    public FeatureTypeStyle createFeatureTypeStyle(Rule[] rules) {
        return new FeatureTypeStyleImpl(rules);
    }

    @Override
    public Rule createRule() {
        return new RuleImpl();
    }

    public Rule createRule(Symbolizer[] symbolizers, org.opengis.style.Description desc, Graphic[] legends, String name, Filter filter, boolean isElseFilter, double maxScale, double minScale) {
        RuleImpl r = new RuleImpl(symbolizers, desc, legends, name, filter, isElseFilter, maxScale, minScale);
        return r;
    }

    public ImageOutline createImageOutline(Symbolizer symbolizer) {
        ImageOutlineImpl outline = new ImageOutlineImpl();
        outline.setSymbolizer(symbolizer);
        return outline;
    }

    @Override
    public Stroke createStroke(Expression color, Expression width) {
        return this.createStroke(color, width, (Expression)this.filterFactory.literal(1.0));
    }

    @Override
    public Stroke createStroke(Expression color, Expression width, Expression opacity) {
        return this.createStroke(color, width, opacity, (Expression)this.filterFactory.literal((Object)"miter"), (Expression)this.filterFactory.literal((Object)"butt"), null, (Expression)this.filterFactory.literal(0.0), null, null);
    }

    @Override
    public Stroke createStroke(Expression color, Expression width, Expression opacity, Expression lineJoin, Expression lineCap, float[] dashArray, Expression dashOffset, Graphic graphicFill, Graphic graphicStroke) {
        StrokeImpl stroke = new StrokeImpl((FilterFactory)this.filterFactory);
        if (color == null) {
            color = Stroke.DEFAULT.getColor();
        }
        stroke.setColor(color);
        if (width == null) {
            width = Stroke.DEFAULT.getWidth();
        }
        stroke.setWidth(width);
        if (opacity == null) {
            opacity = Stroke.DEFAULT.getOpacity();
        }
        stroke.setOpacity(opacity);
        if (lineJoin == null) {
            lineJoin = Stroke.DEFAULT.getLineJoin();
        }
        stroke.setLineJoin(lineJoin);
        if (lineCap == null) {
            lineCap = Stroke.DEFAULT.getLineCap();
        }
        stroke.setLineCap(lineCap);
        stroke.setDashArray(dashArray);
        stroke.setDashOffset(dashOffset);
        stroke.setGraphicFill((org.opengis.style.Graphic)graphicFill);
        stroke.setGraphicStroke((org.opengis.style.Graphic)graphicStroke);
        return stroke;
    }

    @Override
    public Fill createFill(Expression color, Expression backgroundColor, Expression opacity, Graphic graphicFill) {
        FillImpl fill = new FillImpl((FilterFactory)this.filterFactory);
        if (color == null) {
            color = Fill.DEFAULT.getColor();
        }
        fill.setColor(color);
        if (backgroundColor == null) {
            backgroundColor = Fill.DEFAULT.getBackgroundColor();
        }
        fill.setBackgroundColor(backgroundColor);
        if (opacity == null) {
            opacity = Fill.DEFAULT.getOpacity();
        }
        fill.setOpacity(opacity);
        fill.setGraphicFill((org.opengis.style.Graphic)graphicFill);
        return fill;
    }

    @Override
    public Fill createFill(Expression color, Expression opacity) {
        return this.createFill(color, null, opacity, null);
    }

    @Override
    public Fill createFill(Expression color) {
        return this.createFill(color, null, (Expression)this.filterFactory.literal(1.0), null);
    }

    @Override
    public Mark createMark(Expression wellKnownName, Stroke stroke, Fill fill, Expression size, Expression rotation) {
        MarkImpl mark = new MarkImpl((FilterFactory)this.filterFactory, null);
        if (wellKnownName == null) {
            throw new IllegalArgumentException("WellKnownName can not be null in mark");
        }
        mark.setWellKnownName(wellKnownName);
        mark.setStroke((org.opengis.style.Stroke)stroke);
        mark.setFill((org.opengis.style.Fill)fill);
        return mark;
    }

    @Override
    public Mark getSquareMark() {
        Mark mark = this.createMark((Expression)this.filterFactory.literal((Object)"Square"), this.getDefaultStroke(), this.getDefaultFill(), (Expression)this.filterFactory.literal(6), (Expression)this.filterFactory.literal(0));
        return mark;
    }

    @Override
    public Mark getCircleMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)this.filterFactory.literal((Object)"Circle"));
        return mark;
    }

    @Override
    public Mark getCrossMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)this.filterFactory.literal((Object)"Cross"));
        return mark;
    }

    @Override
    public Mark getXMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)this.filterFactory.literal((Object)"X"));
        return mark;
    }

    @Override
    public Mark getTriangleMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)this.filterFactory.literal((Object)"Triangle"));
        return mark;
    }

    @Override
    public Mark getStarMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)this.filterFactory.literal((Object)"Star"));
        return mark;
    }

    @Override
    public Mark createMark() {
        MarkImpl mark = new MarkImpl((FilterFactory)this.filterFactory, null);
        return mark;
    }

    @Override
    public Graphic createGraphic(ExternalGraphic[] externalGraphics, Mark[] marks, Symbol[] symbols, Expression opacity, Expression size, Expression rotation) {
        GraphicImpl graphic = new GraphicImpl((FilterFactory)this.filterFactory);
        symbols = symbols != null ? symbols : new Symbol[]{};
        graphic.setSymbols(symbols);
        if (externalGraphics != null) {
            graphic.graphicalSymbols().addAll(Arrays.asList(externalGraphics));
        }
        if (marks != null) {
            graphic.graphicalSymbols().addAll(Arrays.asList(marks));
        }
        if (opacity == null) {
            opacity = Graphic.DEFAULT.getOpacity();
        }
        graphic.setOpacity(opacity);
        if (size == null) {
            size = Graphic.DEFAULT.getSize();
        }
        graphic.setSize(size);
        if (rotation == null) {
            rotation = Graphic.DEFAULT.getRotation();
        }
        graphic.setRotation(rotation);
        return graphic;
    }

    @Override
    public ExternalGraphic createExternalGraphic(String uri, String format) {
        ExternalGraphicImpl extg = new ExternalGraphicImpl();
        extg.setURI(uri);
        extg.setFormat(format);
        return extg;
    }

    @Override
    public ExternalGraphic createExternalGraphic(Icon inlineContent, String format) {
        ExternalGraphicImpl extg = new ExternalGraphicImpl();
        extg.setInlineContent(inlineContent);
        extg.setFormat(format);
        return extg;
    }

    @Override
    public ExternalGraphic createExternalGraphic(URL url, String format) {
        ExternalGraphicImpl extg = new ExternalGraphicImpl();
        extg.setLocation(url);
        extg.setFormat(format);
        return extg;
    }

    @Override
    public Font createFont(Expression fontFamily, Expression fontStyle, Expression fontWeight, Expression fontSize) {
        FontImpl font = new FontImpl();
        if (fontFamily == null) {
            throw new IllegalArgumentException("Null font family specified");
        }
        font.setFontFamily(fontFamily);
        if (fontSize == null) {
            throw new IllegalArgumentException("Null font size specified");
        }
        font.setFontSize(fontSize);
        if (fontStyle == null) {
            throw new IllegalArgumentException("Null font Style specified");
        }
        font.setFontStyle(fontStyle);
        if (fontWeight == null) {
            throw new IllegalArgumentException("Null font weight specified");
        }
        font.setFontWeight(fontWeight);
        return font;
    }

    @Override
    public LinePlacement createLinePlacement(Expression offset) {
        LinePlacementImpl linep = new LinePlacementImpl((FilterFactory)this.filterFactory);
        linep.setPerpendicularOffset(offset);
        return linep;
    }

    @Override
    public PointPlacement createPointPlacement(AnchorPoint anchorPoint, Displacement displacement, Expression rotation) {
        PointPlacementImpl pointp = new PointPlacementImpl((FilterFactory)this.filterFactory);
        pointp.setAnchorPoint((org.opengis.style.AnchorPoint)anchorPoint);
        pointp.setDisplacement((org.opengis.style.Displacement)displacement);
        pointp.setRotation(rotation);
        return pointp;
    }

    @Override
    public AnchorPoint createAnchorPoint(Expression x, Expression y) {
        AnchorPointImpl anchorPoint = new AnchorPointImpl((FilterFactory)this.filterFactory);
        anchorPoint.setAnchorPointX(x);
        anchorPoint.setAnchorPointY(y);
        return anchorPoint;
    }

    @Override
    public Displacement createDisplacement(Expression x, Expression y) {
        DisplacementImpl displacement = new DisplacementImpl((FilterFactory)this.filterFactory);
        displacement.setDisplacementX(x);
        displacement.setDisplacementY(y);
        return displacement;
    }

    @Override
    public Halo createHalo(Fill fill, Expression radius) {
        HaloImpl halo = new HaloImpl((FilterFactory)this.filterFactory);
        halo.setFill((org.opengis.style.Fill)fill);
        halo.setRadius(radius);
        return halo;
    }

    @Override
    public Fill getDefaultFill() {
        FillImpl fill = new FillImpl((FilterFactory)this.filterFactory);
        try {
            fill.setColor((Expression)this.filterFactory.literal((Object)"#808080"));
            fill.setOpacity((Expression)this.filterFactory.literal((Object)new Double(1.0)));
            fill.setBackgroundColor((Expression)this.filterFactory.literal((Object)"#FFFFFF"));
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating fill", ife);
        }
        return fill;
    }

    @Override
    public LineSymbolizer getDefaultLineSymbolizer() {
        return this.createLineSymbolizer(this.getDefaultStroke(), null);
    }

    @Override
    public Mark getDefaultMark() {
        return this.getSquareMark();
    }

    @Override
    public PointSymbolizer getDefaultPointSymbolizer() {
        return this.createPointSymbolizer(this.createDefaultGraphic(), null);
    }

    @Override
    public PolygonSymbolizer getDefaultPolygonSymbolizer() {
        return this.createPolygonSymbolizer(this.getDefaultStroke(), this.getDefaultFill(), null);
    }

    @Override
    public Stroke getDefaultStroke() {
        try {
            Stroke stroke = this.createStroke((Expression)this.filterFactory.literal((Object)"#000000"), (Expression)this.filterFactory.literal((Object)new Integer(1)));
            stroke.setDashOffset((Expression)this.filterFactory.literal((Object)new Integer(0)));
            stroke.setDashArray(Stroke.DEFAULT.getDashArray());
            stroke.setLineCap((Expression)this.filterFactory.literal((Object)"butt"));
            stroke.setLineJoin((Expression)this.filterFactory.literal((Object)"miter"));
            stroke.setOpacity((Expression)this.filterFactory.literal((Object)new Integer(1)));
            return stroke;
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating stroke", ife);
        }
    }

    @Override
    public Style getDefaultStyle() {
        Style style = this.createStyle();
        return style;
    }

    @Override
    public TextSymbolizer getDefaultTextSymbolizer() {
        return this.createTextSymbolizer(this.getDefaultFill(), new Font[]{this.getDefaultFont()}, null, null, (LabelPlacement)this.getDefaultPointPlacement(), "geometry:text");
    }

    @Override
    public Font getDefaultFont() {
        return FontImpl.createDefault((FilterFactory)this.filterFactory);
    }

    public Graphic createDefaultGraphic() {
        GraphicImpl graphic = new GraphicImpl((FilterFactory)this.filterFactory);
        graphic.addMark(this.createMark());
        graphic.setSize(Expression.NIL);
        graphic.setOpacity((Expression)this.filterFactory.literal(1.0));
        graphic.setRotation((Expression)this.filterFactory.literal(0.0));
        return graphic;
    }

    @Override
    public Graphic getDefaultGraphic() {
        return this.createDefaultGraphic();
    }

    @Override
    public PointPlacement getDefaultPointPlacement() {
        return this.createPointPlacement(this.createAnchorPoint((Expression)this.filterFactory.literal(0), (Expression)this.filterFactory.literal(0.5)), this.createDisplacement((Expression)this.filterFactory.literal(0), (Expression)this.filterFactory.literal(0)), (Expression)this.filterFactory.literal(0));
    }

    public RasterSymbolizer createRasterSymbolizer() {
        return new RasterSymbolizerImpl((FilterFactory)this.filterFactory);
    }

    @Override
    public RasterSymbolizer createRasterSymbolizer(String geometryPropertyName, Expression opacity, ChannelSelection channel, Expression overlap, ColorMap colorMap, ContrastEnhancement cenhancement, ShadedRelief relief, Symbolizer outline) {
        RasterSymbolizerImpl rastersym = new RasterSymbolizerImpl((FilterFactory)this.filterFactory);
        if (geometryPropertyName != null) {
            rastersym.setGeometryPropertyName(geometryPropertyName);
        }
        if (opacity != null) {
            rastersym.setOpacity(opacity);
        }
        if (channel != null) {
            rastersym.setChannelSelection((org.opengis.style.ChannelSelection)channel);
        }
        if (overlap != null) {
            rastersym.setOverlap(overlap);
        }
        if (colorMap != null) {
            rastersym.setColorMap((org.opengis.style.ColorMap)colorMap);
        }
        if (cenhancement != null) {
            rastersym.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cenhancement);
        }
        if (relief != null) {
            rastersym.setShadedRelief((org.opengis.style.ShadedRelief)relief);
        }
        if (outline != null) {
            rastersym.setImageOutline((org.opengis.style.Symbolizer)outline);
        }
        return rastersym;
    }

    @Override
    public RasterSymbolizer getDefaultRasterSymbolizer() {
        return this.createRasterSymbolizer(null, (Expression)this.filterFactory.literal(1.0), null, null, null, null, null, null);
    }

    @Override
    public ChannelSelection createChannelSelection(SelectedChannelType[] channels) {
        ChannelSelectionImpl channelSel = new ChannelSelectionImpl();
        if (channels != null && channels.length > 0) {
            channelSel.setSelectedChannels(channels);
        }
        return channelSel;
    }

    @Override
    public ColorMap createColorMap() {
        return new ColorMapImpl();
    }

    @Override
    public ColorMapEntry createColorMapEntry() {
        return new ColorMapEntryImpl();
    }

    public ContrastEnhancement createContrastEnhancement() {
        return new ContrastEnhancementImpl((FilterFactory)this.filterFactory);
    }

    public ContrastEnhancement createContrastEnhancement(Expression gammaValue) {
        ContrastEnhancementImpl ce = new ContrastEnhancementImpl();
        ce.setGammaValue(gammaValue);
        return ce;
    }

    public SelectedChannelType createSelectedChannelType(String name, ContrastEnhancement enhancement) {
        SelectedChannelTypeImpl sct = new SelectedChannelTypeImpl((FilterFactory)this.filterFactory);
        sct.setChannelName(name);
        sct.setContrastEnhancement((org.opengis.style.ContrastEnhancement)enhancement);
        return sct;
    }

    @Override
    public SelectedChannelType createSelectedChannelType(String name, Expression gammaValue) {
        SelectedChannelTypeImpl sct = new SelectedChannelTypeImpl((FilterFactory)this.filterFactory);
        sct.setChannelName(name);
        sct.setContrastEnhancement((org.opengis.style.ContrastEnhancement)this.createContrastEnhancement(gammaValue));
        return sct;
    }

    public StyledLayerDescriptor createStyledLayerDescriptor() {
        return new StyledLayerDescriptorImpl();
    }

    public UserLayer createUserLayer() {
        return new UserLayerImpl();
    }

    public NamedLayer createNamedLayer() {
        return new NamedLayerImpl();
    }

    public RemoteOWS createRemoteOWS(String service, String onlineResource) {
        RemoteOWSImpl remoteOWS = new RemoteOWSImpl();
        remoteOWS.setService(service);
        remoteOWS.setOnlineResource(onlineResource);
        return remoteOWS;
    }

    public ShadedRelief createShadedRelief(Expression reliefFactor) {
        ShadedReliefImpl relief = new ShadedReliefImpl((FilterFactory)this.filterFactory);
        relief.setReliefFactor(reliefFactor);
        return relief;
    }

    public AnchorPoint anchorPoint(Expression x, Expression y) {
        return this.delegate.anchorPoint(x, y);
    }

    public ChannelSelection channelSelection(org.opengis.style.SelectedChannelType gray) {
        return this.delegate.channelSelection(gray);
    }

    public ChannelSelection channelSelection(org.opengis.style.SelectedChannelType red, org.opengis.style.SelectedChannelType green, org.opengis.style.SelectedChannelType blue) {
        return this.delegate.channelSelection(red, green, blue);
    }

    public ColorMap colorMap(Expression propertyName, Expression ... mapping) {
        return this.delegate.colorMap(propertyName, mapping);
    }

    public ColorReplacementImpl colorReplacement(Expression propertyName, Expression ... mapping) {
        return this.delegate.colorReplacement(propertyName, mapping);
    }

    public ContrastEnhancement contrastEnhancement(Expression gamma, ContrastMethod method) {
        return this.delegate.contrastEnhancement(gamma, method);
    }

    public Description description(InternationalString title, InternationalString description) {
        return this.delegate.description(title, description);
    }

    public Displacement displacement(Expression dx, Expression dy) {
        return this.delegate.displacement(dx, dy);
    }

    public ExternalGraphic externalGraphic(Icon inline, Collection<ColorReplacement> replacements) {
        return this.delegate.externalGraphic(inline, replacements);
    }

    public ExternalGraphic externalGraphic(OnLineResource resource, String format, Collection<ColorReplacement> replacements) {
        return this.delegate.externalGraphic(resource, format, replacements);
    }

    public ExternalMarkImpl externalMark(Icon inline) {
        return this.delegate.externalMark(inline);
    }

    public ExternalMarkImpl externalMark(OnLineResource resource, String format, int markIndex) {
        return this.delegate.externalMark(resource, format, markIndex);
    }

    public FeatureTypeStyle featureTypeStyle(String name, org.opengis.style.Description description, Id definedFor, Set<Name> featureTypeNames, Set<SemanticType> types, List<org.opengis.style.Rule> rules) {
        return this.delegate.featureTypeStyle(name, description, definedFor, featureTypeNames, types, rules);
    }

    public Fill fill(GraphicFill fill, Expression color, Expression opacity) {
        return this.delegate.fill(fill, color, opacity);
    }

    public Font font(List<Expression> family, Expression style, Expression weight, Expression size) {
        return this.delegate.font(family, style, weight, size);
    }

    public Graphic graphic(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, org.opengis.style.AnchorPoint anchor, org.opengis.style.Displacement disp) {
        return this.delegate.graphic(symbols, opacity, size, rotation, anchor, disp);
    }

    public Graphic graphicFill(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, org.opengis.style.AnchorPoint anchorPoint, org.opengis.style.Displacement displacement) {
        return this.delegate.graphicFill(symbols, opacity, size, rotation, anchorPoint, displacement);
    }

    public GraphicLegend graphicLegend(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, org.opengis.style.AnchorPoint anchorPoint, org.opengis.style.Displacement displacement) {
        return this.delegate.graphicLegend(symbols, opacity, size, rotation, anchorPoint, displacement);
    }

    public Graphic graphicStroke(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, org.opengis.style.AnchorPoint anchorPoint, org.opengis.style.Displacement displacement, Expression initialGap, Expression gap) {
        return this.delegate.graphicStroke(symbols, opacity, size, rotation, anchorPoint, displacement, initialGap, gap);
    }

    public Halo halo(org.opengis.style.Fill fill, Expression radius) {
        return this.delegate.halo(fill, radius);
    }

    public LinePlacement linePlacement(Expression offset, Expression initialGap, Expression gap, boolean repeated, boolean aligned, boolean generalizedLine) {
        return this.delegate.linePlacement(offset, initialGap, gap, repeated, aligned, generalizedLine);
    }

    public LineSymbolizer lineSymbolizer(String name, Expression geometry, org.opengis.style.Description description, Unit<?> unit, org.opengis.style.Stroke stroke, Expression offset) {
        return this.delegate.lineSymbolizer(name, geometry, description, unit, stroke, offset);
    }

    public Mark mark(Expression wellKnownName, org.opengis.style.Fill fill, org.opengis.style.Stroke stroke) {
        return this.delegate.mark(wellKnownName, fill, stroke);
    }

    public MarkImpl mark(ExternalMark externalMark, org.opengis.style.Fill fill, org.opengis.style.Stroke stroke) {
        return this.delegate.mark(externalMark, fill, stroke);
    }

    public PointPlacement pointPlacement(org.opengis.style.AnchorPoint anchor, org.opengis.style.Displacement displacement, Expression rotation) {
        return this.delegate.pointPlacement(anchor, displacement, rotation);
    }

    public PointSymbolizer pointSymbolizer(String name, Expression geometry, org.opengis.style.Description description, Unit<?> unit, org.opengis.style.Graphic graphic) {
        return this.delegate.pointSymbolizer(name, geometry, description, unit, graphic);
    }

    public PolygonSymbolizer polygonSymbolizer(String name, Expression geometry, org.opengis.style.Description description, Unit<?> unit, org.opengis.style.Stroke stroke, org.opengis.style.Fill fill, org.opengis.style.Displacement displacement, Expression offset) {
        return this.delegate.polygonSymbolizer(name, geometry, description, unit, stroke, fill, displacement, offset);
    }

    public RasterSymbolizer rasterSymbolizer(String name, Expression geometry, org.opengis.style.Description description, Unit<?> unit, Expression opacity, org.opengis.style.ChannelSelection channelSelection, OverlapBehavior overlapsBehaviour, org.opengis.style.ColorMap colorMap, org.opengis.style.ContrastEnhancement contrast, org.opengis.style.ShadedRelief shaded, org.opengis.style.Symbolizer outline) {
        return this.delegate.rasterSymbolizer(name, geometry, description, unit, opacity, channelSelection, overlapsBehaviour, colorMap, contrast, shaded, outline);
    }

    public ExtensionSymbolizer extensionSymbolizer(String name, String propertyName, org.opengis.style.Description description, Unit<?> unit, String extensionName, Map<String, Expression> parameters) {
        return this.delegate.extensionSymbolizer(name, propertyName, description, unit, extensionName, parameters);
    }

    public Rule rule(String name, org.opengis.style.Description description, org.opengis.style.GraphicLegend legend, double min, double max, List<org.opengis.style.Symbolizer> symbolizers, Filter filter) {
        return this.delegate.rule(name, description, legend, min, max, symbolizers, filter);
    }

    public SelectedChannelType selectedChannelType(String channelName, org.opengis.style.ContrastEnhancement contrastEnhancement) {
        return this.delegate.selectedChannelType(channelName, contrastEnhancement);
    }

    public ShadedRelief shadedRelief(Expression reliefFactor, boolean brightnessOnly) {
        return this.delegate.shadedRelief(reliefFactor, brightnessOnly);
    }

    public Stroke stroke(Expression color, Expression opacity, Expression width, Expression join, Expression cap, float[] dashes, Expression offset) {
        return this.delegate.stroke(color, opacity, width, join, cap, dashes, offset);
    }

    public Stroke stroke(GraphicFill fill, Expression color, Expression opacity, Expression width, Expression join, Expression cap, float[] dashes, Expression offset) {
        return this.delegate.stroke(fill, color, opacity, width, join, cap, dashes, offset);
    }

    public Stroke stroke(GraphicStroke stroke, Expression color, Expression opacity, Expression width, Expression join, Expression cap, float[] dashes, Expression offset) {
        return this.delegate.stroke(stroke, color, opacity, width, join, cap, dashes, offset);
    }

    public Style style(String name, org.opengis.style.Description description, boolean isDefault, List<org.opengis.style.FeatureTypeStyle> featureTypeStyles, org.opengis.style.Symbolizer defaultSymbolizer) {
        return this.delegate.style(name, description, isDefault, featureTypeStyles, defaultSymbolizer);
    }

    public TextSymbolizer textSymbolizer(String name, Expression geometry, org.opengis.style.Description description, Unit<?> unit, Expression label, org.opengis.style.Font font, org.opengis.style.LabelPlacement placement, org.opengis.style.Halo halo, org.opengis.style.Fill fill) {
        return this.delegate.textSymbolizer(name, geometry, description, unit, label, font, placement, halo, fill);
    }
}

