/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.MaxFeaturesSimpleFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class MaxSimpleFeatureCollection
extends DecoratingSimpleFeatureCollection {
    SimpleFeatureCollection delegate;
    long start;
    long max;

    public MaxSimpleFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, long max) {
        this(DataUtilities.simple(delegate), 0L, max);
    }

    public MaxSimpleFeatureCollection(SimpleFeatureCollection delegate, long max) {
        this(delegate, 0L, max);
    }

    public MaxSimpleFeatureCollection(SimpleFeatureCollection delegate, long start, long max) {
        super(delegate);
        this.delegate = delegate;
        this.start = start;
        this.max = max;
    }

    FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(), (FeatureIterator<SimpleFeature>)this.features());
    }

    @Override
    public SimpleFeatureIterator features() {
        return new MaxFeaturesSimpleFeatureIterator(this.delegate.features(), this.start, this.max);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = this.delegate.size();
        if ((long)size < this.start) {
            return 0;
        }
        return (int)Math.min((long)size - this.start, this.max);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty() || this.max == 0L || (long)this.delegate.size() - this.start < 1L;
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T[])new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] a) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        SimpleFeatureIterator i = this.features();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            T[] TArray = list.toArray(a);
            return TArray;
        }
        finally {
            i.close();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds((FeatureCollection<? extends FeatureType, ? extends Feature>)this);
    }
}

