/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Collection;
import org.geotools.feature.NameImpl;
import org.geotools.filter.Expression;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;

public abstract class FilterAbstract
implements Filter {
    protected FilterFactory factory;

    protected FilterAbstract(FilterFactory factory) {
        this.factory = factory;
    }

    public boolean evaluate(SimpleFeature feature) {
        return this.evaluate(feature);
    }

    public boolean accepts(SimpleFeature feature) {
        return this.evaluate(feature);
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return extraData;
    }

    protected Object eval(Expression expression, SimpleFeature feature) {
        if (expression == null || feature == null) {
            return null;
        }
        return expression.evaluate(feature);
    }

    private Object unpack(Object value) {
        if (value instanceof ComplexAttribute) {
            Property simpleContent = ((ComplexAttribute)value).getProperty((Name)new NameImpl("simpleContent"));
            if (simpleContent == null) {
                return null;
            }
            return simpleContent.getValue();
        }
        if (value instanceof Attribute) {
            return ((Attribute)value).getValue();
        }
        return value;
    }

    protected Object eval(org.opengis.filter.expression.Expression expression, Object object) {
        if (expression == null) {
            return null;
        }
        Object value = expression.evaluate(object);
        if (value instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object member : (Collection)value) {
                list.add(this.unpack(member));
            }
            return list;
        }
        return this.unpack(value);
    }

    protected Object eval(org.opengis.filter.expression.Expression expression, Object object, Class context) {
        if (expression == null) {
            return null;
        }
        return expression.evaluate(object, context);
    }
}

