/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.NoSuchElementException;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.filter.Filter;

public class FilteringFeatureIterator<F extends Feature>
implements FeatureIterator<F> {
    protected FeatureIterator<F> delegate;
    protected Filter filter;
    protected F next;

    public FilteringFeatureIterator(FeatureIterator<F> delegate, Filter filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.delegate.hasNext()) {
            Feature peek = this.delegate.next();
            if (!this.filter.evaluate((Object)peek)) continue;
            this.next = peek;
            break;
        }
        return this.next != null;
    }

    public F next() throws NoSuchElementException {
        F f = this.next;
        this.next = null;
        return f;
    }

    public void close() {
        this.delegate.close();
        this.delegate = null;
        this.next = null;
        this.filter = null;
    }
}

