/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.tests;

import junit.framework.TestCase;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.elevation.HgtReader;

public class HgtReaderTest
extends TestCase {
    public void setUp() {
        Main.pref = new Preferences();
    }

    public void testGetElevationFromHgt() {
        this.testHgtData(50.6607106, 8.7337029, "N50E008.hgt", 199);
        this.testHgtData(50.5767627, 9.1938483, "N50E009.hgt", 560);
    }

    private void testHgtData(double lat, double lon, String expTag, int expHeight) {
        LatLon l = new LatLon(lat, lon);
        HgtReader hr = new HgtReader();
        String text = hr.getHgtFileName(l);
        HgtReaderTest.assertEquals((String)expTag, (String)text);
        double d = hr.getElevationFromHgt(l);
        System.out.println(d);
        HgtReaderTest.assertFalse((String)("Data missing or void for coor " + l), (boolean)Double.isNaN(d));
        HgtReaderTest.assertEquals((int)((int)d), (int)expHeight);
    }
}

