/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.GeoidCorrectionKind;
import org.openstreetmap.josm.plugins.elevation.HgtReader;
import org.openstreetmap.josm.plugins.elevation.UnitMode;

public class WayPointHelper {
    public static double METER_TO_FEET = 3.280948;
    private static String[] IMPERIAL_SYSTEM_COUNTRIES = new String[]{"en_US", "en_CA", "en_AU", "en_NZ", "en_ZA"};
    public static final String HEIGHT_ATTRIBUTE = "ele";
    private static UnitMode unitMode = UnitMode.NotSelected;
    private static GeoidCorrectionKind geoidKind = GeoidCorrectionKind.None;
    private static HgtReader hgt = new HgtReader();

    public static GeoidCorrectionKind getGeoidKind() {
        return geoidKind;
    }

    public static void setGeoidKind(GeoidCorrectionKind geoidKind) {
        WayPointHelper.geoidKind = geoidKind;
    }

    public static UnitMode getUnitMode() {
        if (unitMode != UnitMode.NotSelected) {
            return unitMode;
        }
        unitMode = UnitMode.Metric;
        Locale l = Locale.getDefault();
        int i = 0;
        while (i < IMPERIAL_SYSTEM_COUNTRIES.length) {
            String ctry = l.toString();
            if (IMPERIAL_SYSTEM_COUNTRIES[i].equals(ctry)) {
                unitMode = UnitMode.Imperial;
            }
            ++i;
        }
        return unitMode;
    }

    public static String getUnit() {
        switch (WayPointHelper.getUnitMode()) {
            case Metric: {
                return "m";
            }
            case Imperial: {
                return "ft";
            }
        }
        throw new RuntimeException("Invalid or unsupported unit mode: " + (Object)((Object)unitMode));
    }

    public static double getElevation(WayPoint wpt) {
        double ele = WayPointHelper.getInternalElevation(wpt);
        if (WayPointHelper.getUnitMode() == UnitMode.Imperial) {
            return WayPointHelper.meter2Feet(ele);
        }
        return ele;
    }

    public static double computeSlope(WayPoint w1, WayPoint w2) {
        if (w1.getCoor().equals((Object)w2.getCoor())) {
            return 0.0;
        }
        double distInMeter = w1.getCoor().greatCircleDistance(w2.getCoor()) / 100.0;
        if (WayPointHelper.getUnitMode() == UnitMode.Imperial) {
            distInMeter = WayPointHelper.meter2Feet(distInMeter);
        }
        int ele1 = (int)WayPointHelper.getElevation(w1);
        int ele2 = (int)WayPointHelper.getElevation(w2);
        int dH = ele2 - ele1;
        return (double)dH / distInMeter;
    }

    public static double meter2Feet(double meter) {
        return meter * METER_TO_FEET;
    }

    public static String getElevationText(int elevation) {
        return String.format("%d %s", elevation, WayPointHelper.getUnit());
    }

    public static String getElevationText(double elevation) {
        return String.format("%d %s", (int)Math.round(elevation), WayPointHelper.getUnit());
    }

    public static String getElevationText(WayPoint wpt) {
        if (wpt == null) {
            return null;
        }
        int elevation = (int)Math.round(WayPointHelper.getElevation(wpt));
        return String.format("%d %s", elevation, WayPointHelper.getUnit());
    }

    public static String getTimeText(WayPoint wpt) {
        if (wpt == null) {
            return null;
        }
        int hour = WayPointHelper.getHourOfWayPoint(wpt);
        int min = WayPointHelper.getMinuteOfWayPoint(wpt);
        return String.format("%02d:%02d", hour, min);
    }

    private static double getInternalElevation(WayPoint wpt) {
        if (wpt != null) {
            double eleHgt = hgt.getElevationFromHgt(wpt.getCoor());
            if (!Double.isNaN(eleHgt)) {
                return eleHgt;
            }
            if (!wpt.attr.containsKey(HEIGHT_ATTRIBUTE)) {
                return 0.0;
            }
            String height = wpt.getString(HEIGHT_ATTRIBUTE);
            try {
                double z = Double.parseDouble(height);
                if (geoidKind == GeoidCorrectionKind.Auto) {
                    byte h = WayPointHelper.getGeoidCorrection(wpt);
                    z += (double)h;
                }
                return z;
            }
            catch (NumberFormatException e) {
                System.err.println(String.format("Cannot parse double from '%s': %s", height, e.getMessage()));
                return 0.0;
            }
        }
        return 0.0;
    }

    public static byte getGeoidCorrection(WayPoint wpt) {
        return 0;
    }

    public static List<WayPoint> downsampleWayPoints(List<WayPoint> origList, int targetSize) {
        if (origList == null) {
            return null;
        }
        if (targetSize <= 0) {
            throw new IllegalArgumentException("targetSize must be greater than zero");
        }
        int origSize = origList.size();
        if (origSize <= targetSize) {
            return origList;
        }
        int delta = (int)Math.max(Math.ceil(origSize / targetSize), 2.0);
        ArrayList<WayPoint> res = new ArrayList<WayPoint>(targetSize);
        int i = 0;
        while (i < origSize) {
            res.add(origList.get(i));
            i += delta;
        }
        return res;
    }

    public static int getHourOfWayPoint(WayPoint wpt) {
        if (wpt == null) {
            return -1;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(wpt.getTime());
        return calendar.get(11);
    }

    public static int getMinuteOfWayPoint(WayPoint wpt) {
        if (wpt == null) {
            return -1;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(wpt.getTime());
        return calendar.get(12);
    }
}

