/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.util.List;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.ElevationProfileBase;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.WayPointHelper;

public class ElevationProfileLeaf
extends ElevationProfileBase {
    public ElevationProfileLeaf(String name, IElevationProfile parent, List<WayPoint> wayPoints) {
        super(name, parent, wayPoints, 0);
    }

    @Override
    public int elevationValueAt(int i) {
        if (i < 0 || i >= this.getNumberOfWayPoints()) {
            throw new IndexOutOfBoundsException("Wrong index: " + i);
        }
        return (int)WayPointHelper.getElevation(this.getWayPoints().get(i));
    }

    @Override
    public List<IElevationProfile> getChildren() {
        return null;
    }

    @Override
    public String toString() {
        return "ElevationModelSlice [avrgEle=" + this.getAverageHeight() + ", maxEle=" + this.getMaxHeight() + ", minEle=" + this.getMinHeight() + ", name=" + this.getName() + ", wayPoints=" + this.getNumberOfWayPoints() + "]";
    }
}

