/*
 * Decompiled with CFR 0.152.
 */
package geochat;

import geochat.GeoChatPanel;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.I18n;

class GeoChatPopupAdapter
extends MouseAdapter {
    private GeoChatPanel panel;

    public GeoChatPopupAdapter(GeoChatPanel panel) {
        this.panel = panel;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.check(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.check(e);
    }

    private void check(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JPopupMenu createPopupMenu() {
        JMenu userMenu = new JMenu(I18n.tr((String)"Private chat", (Object[])new Object[0]));
        for (String user : this.panel.users.keySet()) {
            if (this.panel.chatPanes.hasUser(user)) continue;
            userMenu.add(new PrivateChatAction(user));
        }
        JPopupMenu menu = new JPopupMenu();
        if (this.panel.chatPanes.hasSelectedText()) {
            menu.add(new CopyTextAction());
        }
        menu.add(new JCheckBoxMenuItem(new ToggleUserLayerAction()));
        if (userMenu.getItemCount() > 0) {
            menu.add(userMenu);
        }
        if (this.panel.chatPanes.getRecipient() != null) {
            menu.add(new CloseTabAction());
        }
        menu.add(new LogoutAction());
        return menu;
    }

    private class CopyTextAction
    extends AbstractAction {
        public CopyTextAction() {
            super(I18n.tr((String)"Copy", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((GeoChatPopupAdapter)GeoChatPopupAdapter.this).panel.chatPanes.copySelectedText();
        }
    }

    private class ToggleUserLayerAction
    extends AbstractAction {
        public ToggleUserLayerAction() {
            super(I18n.tr((String)"Show users on map", (Object[])new Object[0]));
            this.putValue("SwingSelectedKey", ((GeoChatPopupAdapter)GeoChatPopupAdapter.this).panel.userLayerActive);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Main.map == null || Main.map.mapView == null) {
                return;
            }
            boolean wasAdded = Main.map.mapView.addTemporaryLayer((MapViewPaintable)GeoChatPopupAdapter.this.panel);
            if (!wasAdded) {
                Main.map.mapView.removeTemporaryLayer((MapViewPaintable)GeoChatPopupAdapter.this.panel);
            }
            ((GeoChatPopupAdapter)GeoChatPopupAdapter.this).panel.userLayerActive = wasAdded;
            this.putValue("SwingSelectedKey", ((GeoChatPopupAdapter)GeoChatPopupAdapter.this).panel.userLayerActive);
            Main.map.mapView.repaint();
        }
    }

    private class ClearPaneAction
    extends AbstractAction {
        public ClearPaneAction() {
            super(I18n.tr((String)"Clear log", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((GeoChatPopupAdapter)GeoChatPopupAdapter.this).panel.chatPanes.clearActiveChatPane();
        }
    }

    private class LogoutAction
    extends AbstractAction {
        public LogoutAction() {
            super(I18n.tr((String)"Logout", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeoChatPopupAdapter.this.panel.logout();
        }
    }

    private class CloseTabAction
    extends AbstractAction {
        public CloseTabAction() {
            super(I18n.tr((String)"Close tab", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((GeoChatPopupAdapter)GeoChatPopupAdapter.this).panel.chatPanes.closeSelectedPrivatePane();
        }
    }

    private class PrivateChatAction
    extends AbstractAction {
        private String userName;

        public PrivateChatAction(String userName) {
            super(userName);
            this.userName = userName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!((GeoChatPopupAdapter)GeoChatPopupAdapter.this).panel.chatPanes.hasUser(this.userName)) {
                ((GeoChatPopupAdapter)GeoChatPopupAdapter.this).panel.chatPanes.createChatPane(this.userName);
            }
        }
    }
}

