/*
 * Decompiled with CFR 0.152.
 */
package geochat;

import geochat.ChatMessage;
import geochat.ChatServerConnectionListener;
import geochat.JsonQueryCallback;
import geochat.JsonQueryUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.I18n;

class ChatServerConnection {
    public static final String TOKEN_PREFIX = "=";
    private static final String TOKEN_PATTERN = "^[a-zA-Z0-9]{10}$";
    private int userId = 0;
    private String userName = null;
    private static ChatServerConnection instance;
    private Set<ChatServerConnectionListener> listeners = new HashSet<ChatServerConnectionListener>();
    private LogRequest requestThread = new LogRequest();

    private ChatServerConnection() {
        new Thread(this.requestThread).start();
    }

    public static ChatServerConnection getInstance() {
        if (instance == null) {
            instance = new ChatServerConnection();
        }
        return instance;
    }

    public void addListener(ChatServerConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChatServerConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isActive() {
        return this.isLoggedIn() && ChatServerConnection.getPosition() != null;
    }

    public boolean isLoggedIn() {
        return this.userId > 0;
    }

    public String getUserName() {
        return this.userName;
    }

    public void checkLogin() {
        this.autoLogin(null);
    }

    public void autoLogin(final String userName) {
        final int uid = Main.pref.getInteger("geochat.lastuid", 0);
        if (uid <= 0) {
            if (userName != null && userName.length() > 1) {
                this.login(userName);
            }
        } else {
            String query = "whoami&uid=" + uid;
            JsonQueryUtil.queryAsync(query, new JsonQueryCallback(){

                @Override
                public void processJson(JSONObject json) {
                    if (json != null && json.has("name")) {
                        ChatServerConnection.this.login(uid, json.getString("name"));
                    } else if (userName != null && userName.length() > 1) {
                        ChatServerConnection.this.login(userName);
                    }
                }
            });
        }
    }

    public void autoLoginWithDelay(final String userName) {
        if (userName == null || userName.length() == 0) {
            this.checkLogin();
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int cnt = 10;
                    while (ChatServerConnection.getPosition() == null && cnt-- > 0) {
                        Thread.sleep(200L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ChatServerConnection.this.autoLogin(userName);
            }
        }).start();
    }

    public void login(final String userName) {
        String token;
        if (userName == null) {
            throw new IllegalArgumentException("userName is null");
        }
        LatLon pos = ChatServerConnection.getPosition();
        if (pos == null) {
            this.fireLoginFailed("Position is unknown");
            return;
        }
        String string = token = userName.startsWith(TOKEN_PREFIX) ? userName.substring(TOKEN_PREFIX.length()) : null;
        if (token != null && !token.matches(TOKEN_PATTERN)) {
            this.fireLoginFailed("Incorrect token format");
            return;
        }
        try {
            String nameAttr = token != null ? "&token=" + token : "&name=" + URLEncoder.encode(userName, "UTF-8");
            String query = "register&lat=" + pos.latToString(CoordinateFormat.DECIMAL_DEGREES) + "&lon=" + pos.lonToString(CoordinateFormat.DECIMAL_DEGREES) + nameAttr;
            JsonQueryUtil.queryAsync(query, new JsonQueryCallback(){

                @Override
                public void processJson(JSONObject json) {
                    if (json == null) {
                        ChatServerConnection.this.fireLoginFailed(I18n.tr((String)"Could not get server response, check logs", (Object[])new Object[0]));
                    } else if (json.has("error")) {
                        ChatServerConnection.this.fireLoginFailed(I18n.tr((String)"Failed to login as {0}:", (Object[])new Object[]{userName}) + "\n" + json.getString("error"));
                    } else if (!json.has("uid")) {
                        ChatServerConnection.this.fireLoginFailed(I18n.tr((String)"The server did not return user ID", (Object[])new Object[0]));
                    } else {
                        String name = json.has("name") ? json.getString("name") : userName;
                        ChatServerConnection.this.login(json.getInt("uid"), name);
                    }
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    private void login(int userId, String userName) {
        this.userId = userId;
        this.userName = userName;
        Main.pref.putInteger("geochat.lastuid", Integer.valueOf(userId));
        for (ChatServerConnectionListener listener : this.listeners) {
            listener.loggedIn(userName);
        }
    }

    private void logoutIntl() {
        this.userId = 0;
        this.userName = null;
        Main.pref.put("geochat.lastuid", null);
        for (ChatServerConnectionListener listener : this.listeners) {
            listener.notLoggedIn(null);
        }
    }

    private void fireLoginFailed(String reason) {
        for (ChatServerConnectionListener listener : this.listeners) {
            listener.notLoggedIn(reason);
        }
    }

    public void logout() {
        if (!this.isLoggedIn()) {
            return;
        }
        String query = "logout&uid=" + this.userId;
        JsonQueryUtil.queryAsync(query, new JsonQueryCallback(){

            @Override
            public void processJson(JSONObject json) {
                if (json != null && json.has("message")) {
                    ChatServerConnection.this.logoutIntl();
                }
            }
        });
    }

    public void bruteLogout() throws IOException {
        if (this.isLoggedIn()) {
            JsonQueryUtil.query("logout&uid=" + this.userId);
        }
    }

    private void fireMessageFailed(String reason) {
        for (ChatServerConnectionListener listener : this.listeners) {
            listener.messageSendFailed(reason);
        }
    }

    public void postMessage(String message) {
        this.postMessage(message, null);
    }

    public void postMessage(String message, String targetUser) {
        if (!this.isLoggedIn()) {
            this.fireMessageFailed("Not logged in");
            return;
        }
        LatLon pos = ChatServerConnection.getPosition();
        if (pos == null) {
            this.fireMessageFailed("Position is unknown");
            return;
        }
        try {
            String query = "post&lat=" + pos.latToString(CoordinateFormat.DECIMAL_DEGREES) + "&lon=" + pos.lonToString(CoordinateFormat.DECIMAL_DEGREES) + "&uid=" + this.userId + "&message=" + URLEncoder.encode(message, "UTF8");
            if (targetUser != null && targetUser.length() > 0) {
                query = query + "&to=" + URLEncoder.encode(targetUser, "UTF8");
            }
            JsonQueryUtil.queryAsync(query, new JsonQueryCallback(){

                @Override
                public void processJson(JSONObject json) {
                    if (json == null) {
                        ChatServerConnection.this.fireMessageFailed(I18n.tr((String)"Could not get server response, check logs", (Object[])new Object[0]));
                    } else if (json.has("error")) {
                        ChatServerConnection.this.fireMessageFailed(I18n.tr((String)"Failed to send message:", (Object[])new Object[0]) + "\n" + json.getString("error"));
                    }
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    private static LatLon getPosition() {
        if (Main.map == null || Main.map.mapView == null) {
            return null;
        }
        if (ChatServerConnection.getCurrentZoom() < 10) {
            return null;
        }
        Projection proj = Main.getProjection();
        return proj.eastNorth2latlon(Main.map.mapView.getCenter());
    }

    private static double latToTileY(double lat, int zoom) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return Math.pow(2.0, zoom - 1) * (Math.PI - pf) / Math.PI;
    }

    private static double lonToTileX(double lon, int zoom) {
        return Math.pow(2.0, zoom - 3) * (lon + 180.0) / 45.0;
    }

    public static int getCurrentZoom() {
        if (Main.map == null || Main.map.mapView == null) {
            return 1;
        }
        MapView mv = Main.map.mapView;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        double x1 = ChatServerConnection.lonToTileX(topLeft.lon(), 1);
        double y1 = ChatServerConnection.latToTileY(topLeft.lat(), 1);
        double x2 = ChatServerConnection.lonToTileX(botRight.lon(), 1);
        double y2 = ChatServerConnection.latToTileY(botRight.lat(), 1);
        int screenPixels = mv.getWidth() * mv.getHeight();
        double tilePixels = Math.abs((y2 - y1) * (x2 - x1) * 256.0 * 256.0);
        if (screenPixels == 0 || tilePixels == 0.0) {
            return 1;
        }
        double factor = (double)screenPixels / tilePixels;
        double result = Math.log(factor) / Math.log(2.0) / 2.0 + 1.0;
        int intResult = (int)Math.floor(result);
        return intResult;
    }

    private class LogRequest
    implements Runnable {
        private static final int MAX_JUMP = 20000;
        private LatLon lastPosition = null;
        private long lastUserId = 0L;
        private long lastId = 0L;
        private boolean lastStatus = false;
        private boolean stopping = false;

        private LogRequest() {
        }

        @Override
        public void run() {
            int interval = Main.pref.getInteger("geochat.interval", 2);
            while (!this.stopping) {
                this.process();
                try {
                    Thread.sleep(interval * 1000);
                }
                catch (InterruptedException e) {
                    this.stopping = true;
                }
            }
        }

        public void stop() {
            this.stopping = true;
        }

        public void process() {
            boolean needReset;
            boolean needFullReset;
            if (!ChatServerConnection.this.isLoggedIn()) {
                this.fireStatusChanged(false);
                return;
            }
            LatLon pos = ChatServerConnection.getPosition();
            if (pos == null) {
                this.fireStatusChanged(false);
                return;
            }
            this.fireStatusChanged(true);
            boolean bl = needFullReset = this.lastUserId != (long)ChatServerConnection.this.userId;
            if (needFullReset || this.lastPosition != null && pos.greatCircleDistance(this.lastPosition) > 20000.0) {
                this.lastId = 0L;
                needReset = true;
            } else {
                needReset = false;
            }
            this.lastUserId = ChatServerConnection.this.userId;
            this.lastPosition = pos;
            String query = "get&lat=" + pos.latToString(CoordinateFormat.DECIMAL_DEGREES) + "&lon=" + pos.lonToString(CoordinateFormat.DECIMAL_DEGREES) + "&uid=" + ChatServerConnection.this.userId + "&last=" + this.lastId;
            JsonQueryUtil.queryAsync(query, new JsonQueryCallback(){

                @Override
                public void processJson(JSONObject json) {
                    if (json != null) {
                        if (json.has("error")) {
                            ChatServerConnection.this.fireLoginFailed(I18n.tr((String)"Failed to get messages as {0}:", (Object[])new Object[]{ChatServerConnection.this.userName}) + "\n" + json.getString("error"));
                            ChatServerConnection.this.logoutIntl();
                        } else {
                            List messages;
                            if (json.has("users")) {
                                Map users = LogRequest.this.parseUsers(json.getJSONArray("users"));
                                for (ChatServerConnectionListener listener : ChatServerConnection.this.listeners) {
                                    listener.updateUsers(users);
                                }
                            }
                            if (json.has("messages")) {
                                messages = LogRequest.this.parseMessages(json.getJSONArray("messages"), false);
                                for (ChatMessage m : messages) {
                                    if (m.getId() <= LogRequest.this.lastId) continue;
                                    LogRequest.this.lastId = m.getId();
                                }
                                for (ChatServerConnectionListener listener : ChatServerConnection.this.listeners) {
                                    listener.receivedMessages(needReset, messages);
                                }
                            }
                            if (json.has("private")) {
                                messages = LogRequest.this.parseMessages(json.getJSONArray("private"), true);
                                for (ChatMessage m : messages) {
                                    if (m.getId() <= LogRequest.this.lastId) continue;
                                    LogRequest.this.lastId = m.getId();
                                }
                                for (ChatServerConnectionListener listener : ChatServerConnection.this.listeners) {
                                    listener.receivedPrivateMessages(needFullReset, messages);
                                }
                            }
                        }
                    }
                }
            });
        }

        private List<ChatMessage> parseMessages(JSONArray messages, boolean priv) {
            ArrayList<ChatMessage> result = new ArrayList<ChatMessage>();
            for (int i = 0; i < messages.length(); ++i) {
                try {
                    JSONObject msg = messages.getJSONObject(i);
                    long id = msg.getLong("id");
                    double lat = msg.getDouble("lat");
                    double lon = msg.getDouble("lon");
                    long timeStamp = msg.getLong("timestamp");
                    String author = msg.getString("author");
                    String message = msg.getString("message");
                    boolean incoming = msg.getBoolean("incoming");
                    ChatMessage cm = new ChatMessage(id, new LatLon(lat, lon), author, incoming, message, new Date(timeStamp * 1000L));
                    cm.setPrivate(priv);
                    if (msg.has("recipient") && !incoming) {
                        cm.setRecipient(msg.getString("recipient"));
                    }
                    result.add(cm);
                    continue;
                }
                catch (JSONException e) {
                    // empty catch block
                }
            }
            return result;
        }

        private Map<String, LatLon> parseUsers(JSONArray users) {
            HashMap<String, LatLon> result = new HashMap<String, LatLon>();
            for (int i = 0; i < users.length(); ++i) {
                try {
                    JSONObject user = users.getJSONObject(i);
                    String name = user.getString("user");
                    double lat = user.getDouble("lat");
                    double lon = user.getDouble("lon");
                    result.put(name, new LatLon(lat, lon));
                    continue;
                }
                catch (JSONException e) {
                    // empty catch block
                }
            }
            return result;
        }

        private void fireStatusChanged(boolean newStatus) {
            if (newStatus == this.lastStatus) {
                return;
            }
            this.lastStatus = newStatus;
            for (ChatServerConnectionListener listener : ChatServerConnection.this.listeners) {
                listener.statusChanged(newStatus);
            }
        }
    }
}

