/*
 * Decompiled with CFR 0.152.
 */
package poly;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmExporter;
import poly.PolyType;

public class PolyExporter
extends OsmExporter {
    public PolyExporter() {
        super(PolyType.FILE_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportData(File file, Layer layer) throws IOException {
        if (layer instanceof OsmDataLayer) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            try {
                DataSet ds = ((OsmDataLayer)layer).data;
                Map<Way, Boolean> ways = new TreeMap<Way, Boolean>();
                String polygonName = file.getName();
                if (polygonName.indexOf(46) > 0) {
                    polygonName = polygonName.substring(0, polygonName.indexOf(46));
                }
                for (Way w : ds.getWays()) {
                    if (!w.isClosed()) continue;
                    boolean outer = this.isOuter(w);
                    ways.put(w, outer);
                    if (!w.hasKey("name")) continue;
                    polygonName = w.get("name").replace("\n", " ");
                }
                ways = this.sortOuterInner(ways);
                int counter = 1;
                writer.write(polygonName);
                writer.newLine();
                for (Way w : ways.keySet()) {
                    if (!ways.get(w).booleanValue()) {
                        writer.write(33);
                    }
                    writer.write(String.valueOf(counter++));
                    writer.newLine();
                    for (Node n : w.getNodes()) {
                        writer.write(String.format(Locale.ENGLISH, "   %f   %f", n.getCoor().lon(), n.getCoor().lat()));
                        writer.newLine();
                    }
                    writer.write("END");
                    writer.newLine();
                }
                writer.write("END");
                writer.newLine();
            }
            finally {
                writer.close();
            }
        }
    }

    private boolean isOuter(Way w) {
        for (OsmPrimitive p : w.getReferrers()) {
            if (!(p instanceof Relation) || !((Relation)p).isMultipolygon()) continue;
            for (RelationMember m : ((Relation)p).getMembers()) {
                if (!m.refersTo((OsmPrimitive)w) || !"inner".equals(m.getRole())) continue;
                return false;
            }
        }
        return true;
    }

    private Map<Way, Boolean> sortOuterInner(Map<Way, Boolean> ways) {
        LinkedHashMap<Way, Boolean> result = new LinkedHashMap<Way, Boolean>(ways.size());
        ArrayList<Way> inner = new ArrayList<Way>();
        for (Way w : ways.keySet()) {
            Boolean outer = ways.get(w);
            if (outer.booleanValue()) {
                result.put(w, outer);
                continue;
            }
            inner.add(w);
        }
        for (Way w : inner) {
            result.put(w, Boolean.FALSE);
        }
        return result;
    }
}

