/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.util.Collections;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreet;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditTableModel;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreetTableModel
extends AddressEditTableModel {
    private static final int NUMBER_OF_COLUMNS = 3;
    private static final String[] COLUMN_NAMES = new String[]{I18n.tr((String)"Type", (Object[])new Object[0]), I18n.tr((String)"Name", (Object[])new Object[0]), I18n.tr((String)"Addresses", (Object[])new Object[0])};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, Integer.class};

    public StreetTableModel(AddressEditContainer addressContainer) {
        super(addressContainer);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public int getRowCount() {
        if (this.addressContainer == null || this.addressContainer.getStreetList() == null) {
            return 0;
        }
        return this.addressContainer.getNumberOfStreets();
    }

    @Override
    public Object getValueAt(int row, int column) {
        OSMStreet sNode = (OSMStreet)this.getEntityOfRow(row);
        if (sNode == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return sNode.getType();
            }
            case 1: {
                return sNode.getName();
            }
            case 2: {
                return sNode.getNumberOfSegments();
            }
            case 3: {
                return sNode.getNumberOfAddresses();
            }
            case 4: {
                return sNode.hasAssociatedStreetRelation();
            }
        }
        throw new RuntimeException("Invalid column index: " + column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public IOSMEntity getEntityOfRow(int row) {
        if (this.addressContainer == null || this.addressContainer.getStreetList() == null) {
            return null;
        }
        if (row < 0 || row >= this.addressContainer.getNumberOfStreets()) {
            return null;
        }
        return this.addressContainer.getStreetList().get(row);
    }

    @Override
    public int getRowOfEntity(IOSMEntity entity) {
        if (this.addressContainer == null || this.addressContainer.getStreetList() == null) {
            return -1;
        }
        return this.addressContainer.getStreetList().indexOf(entity);
    }

    @Override
    protected void sortByColumn(int column, boolean ascending) {
        Collections.sort(this.addressContainer.getStreetList(), new StreetModelSorter(column, ascending));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StreetModelSorter
    extends AddressEditTableModel.ColumnSorter<OSMStreet> {
        public StreetModelSorter(int column, boolean asc) {
            super(column, asc);
        }

        @Override
        public int compare(OSMStreet arg0, OSMStreet arg1) {
            if (arg0 == null || arg1 == null) {
                return 0;
            }
            switch (this.getColumn()) {
                case 0: {
                    if (arg0.getType() != null) {
                        return arg0.getType().compareTo(arg1.getType());
                    }
                    return arg1.hasName() ? -1 : 0;
                }
                case 1: {
                    if (arg0.hasName()) {
                        return arg0.getName().compareTo(arg1.getName());
                    }
                    return arg1.hasName() ? -1 : 0;
                }
                case 2: {
                    return new Integer(arg0.getNumberOfAddresses()).compareTo(new Integer(arg1.getNumberOfAddresses()));
                }
            }
            return 0;
        }
    }
}

