/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.wikipedia.WikipediaApp;

public class WikipediaToggleDialog
extends ToggleDialog
implements MapView.EditLayerChangeListener,
DataSetListenerAdapter.Listener {
    final StringProperty wikipediaLang = new StringProperty("wikipedia.lang", LanguageInfo.getJOSMLocaleCode().substring(0, 2));
    final Set<String> articles = new HashSet<String>();
    final DefaultListModel model = new DefaultListModel();
    final JList list = new JList(this.model){
        {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && this.getSelectedValue() != null) {
                        WikipediaApp.WikipediaEntry entry = (WikipediaApp.WikipediaEntry)this.getSelectedValue();
                        if (entry.coordinate != null) {
                            BoundingXYVisitor bbox = new BoundingXYVisitor();
                            bbox.visit(entry.coordinate);
                            Main.map.mapView.recalculateCenterScale(bbox);
                        }
                        SearchAction.search((String)entry.name.replaceAll("\\(.*\\)", ""), (SearchAction.SearchMode)SearchAction.SearchMode.replace);
                    }
                }
            });
            this.setCellRenderer(new DefaultListCellRenderer(){

                public JLabel getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    WikipediaApp.WikipediaEntry entry = (WikipediaApp.WikipediaEntry)value;
                    if (entry.getWiwosmStatus() != null && entry.getWiwosmStatus().booleanValue()) {
                        label.setIcon(ImageProvider.getIfAvailable((String)"misc", (String)"grey_check"));
                        label.setToolTipText(I18n.tr((String)"Available via WIWOSM server", (Object[])new Object[0]));
                    } else if (WikipediaToggleDialog.this.articles.contains(entry.wikipediaArticle)) {
                        label.setIcon(ImageProvider.getIfAvailable((String)"misc", (String)"green_check"));
                        label.setToolTipText(I18n.tr((String)"Available in local dataset", (Object[])new Object[0]));
                    } else {
                        label.setToolTipText(I18n.tr((String)"Not linked yet", (Object[])new Object[0]));
                    }
                    if (entry.description != null) {
                        label.setToolTipText("<html>" + entry.description + "</html>");
                    }
                    return label;
                }
            });
        }
    };
    private final DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter((DataSetListenerAdapter.Listener)this);

    public WikipediaToggleDialog() {
        super(I18n.tr((String)"Wikipedia", (Object[])new Object[0]), "wikipedia", I18n.tr((String)"Fetch Wikipedia articles with coordinates", (Object[])new Object[0]), null, 150);
        this.createLayout(this.list, true, Arrays.asList(new SideButton((Action)new WikipediaLoadCoordinatesAction()), new SideButton((Action)new WikipediaLoadCategoryAction()), new SideButton((Action)new AddWikipediaTagAction()), new SideButton((Action)new OpenWikipediaArticleAction()), new SideButton((Action)new WikipediaSettingsAction(), false)));
        this.setTitle(I18n.tr((String)"{0}.Wikipedia.org", (Object[])new Object[]{this.wikipediaLang.get()}));
    }

    private void setWikipediaEntries(List<WikipediaApp.WikipediaEntry> entries) {
        Collections.sort(entries);
        WikipediaApp.updateWIWOSMStatus(this.wikipediaLang.get(), entries);
        this.model.clear();
        for (WikipediaApp.WikipediaEntry i : entries) {
            this.model.addElement(i);
        }
    }

    protected void updateWikipediaArticles() {
        this.articles.clear();
        if (Main.main != null && Main.main.getCurrentDataSet() != null) {
            for (OsmPrimitive p : Main.main.getCurrentDataSet().allPrimitives()) {
                this.articles.addAll(WikipediaApp.getWikipediaArticles(this.wikipediaLang.get(), p));
            }
        }
    }

    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        this.updateWikipediaArticles();
    }

    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener((DataSetListener)this.dataChangedAdapter);
        MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        this.articles.clear();
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        this.updateWikipediaArticles();
        this.list.repaint();
    }

    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.updateWikipediaArticles();
        this.list.repaint();
    }

    class AddWikipediaTagAction
    extends AbstractAction {
        public AddWikipediaTagAction() {
            super(I18n.tr((String)"Add Tag", (Object[])new Object[0]), ImageProvider.get((String)"pastetags"));
            this.putValue("ShortDescription", I18n.tr((String)"Adds a ''wikipedia'' tag corresponding to this article to the selected objects", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tag tag;
            if (WikipediaToggleDialog.this.list.getSelectedValue() != null && (tag = ((WikipediaApp.WikipediaEntry)WikipediaToggleDialog.this.list.getSelectedValue()).createWikipediaTag()) != null) {
                ChangePropertyCommand cmd = new ChangePropertyCommand(Main.main.getCurrentDataSet().getSelected(), tag.getKey(), tag.getValue());
                Main.main.undoRedo.add((Command)cmd);
            }
        }
    }

    class WikipediaSettingsAction
    extends AbstractAction {
        public WikipediaSettingsAction() {
            super(I18n.tr((String)"Language", (Object[])new Object[0]), ImageProvider.get((String)"dialogs/settings"));
            this.putValue("ShortDescription", I18n.tr((String)"Sets the default language for the Wikipedia articles", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String lang = JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"Enter the Wikipedia language", (Object[])new Object[0]), WikipediaToggleDialog.this.wikipediaLang.get());
            if (lang != null) {
                WikipediaToggleDialog.this.wikipediaLang.put(lang);
                WikipediaToggleDialog.this.updateWikipediaArticles();
            }
        }
    }

    class OpenWikipediaArticleAction
    extends AbstractAction {
        public OpenWikipediaArticleAction() {
            super(I18n.tr((String)"Open Article", (Object[])new Object[0]), ImageProvider.getIfAvailable((String)"browser"));
            this.putValue("ShortDescription", I18n.tr((String)"Opens the Wikipedia article of the selected item in a browser", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WikipediaToggleDialog.this.list.getSelectedValue() != null) {
                String url = ((WikipediaApp.WikipediaEntry)WikipediaToggleDialog.this.list.getSelectedValue()).getBrowserUrl();
                System.out.println("Wikipedia: opening " + url);
                OpenBrowser.displayUrl((String)url);
            }
        }
    }

    class WikipediaLoadCategoryAction
    extends AbstractAction {
        public WikipediaLoadCategoryAction() {
            super(I18n.tr((String)"Category", (Object[])new Object[0]), ImageProvider.get((String)"dialogs", (String)"refresh"));
            this.putValue("ShortDescription", I18n.tr((String)"Fetches a list of all Wikipedia articles of a category", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String category = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"Enter the Wikipedia category", (Object[])new Object[0]));
            if (category == null) {
                return;
            }
            List<WikipediaApp.WikipediaEntry> entries = WikipediaApp.getEntriesFromCategory(WikipediaToggleDialog.this.wikipediaLang.get(), category, Main.pref.getInteger("wikipedia.depth", 3));
            WikipediaToggleDialog.this.setWikipediaEntries(entries);
            WikipediaToggleDialog.this.setTitle(I18n.tr((String)"{0}.Wikipedia.org: {1}", (Object[])new Object[]{WikipediaToggleDialog.this.wikipediaLang.get(), category}));
        }
    }

    class WikipediaLoadCoordinatesAction
    extends AbstractAction {
        public WikipediaLoadCoordinatesAction() {
            super(I18n.tr((String)"Coordinates", (Object[])new Object[0]), ImageProvider.get((String)"dialogs", (String)"refresh"));
            this.putValue("ShortDescription", I18n.tr((String)"Fetches all coordinates from Wikipedia in the current view", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                LatLon min = Main.map.mapView.getLatLon(0, Main.map.mapView.getHeight());
                LatLon max = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), 0);
                List<WikipediaApp.WikipediaEntry> entries = WikipediaApp.getEntriesFromCoordinates(WikipediaToggleDialog.this.wikipediaLang.get(), min, max);
                WikipediaToggleDialog.this.setWikipediaEntries(entries);
                WikipediaToggleDialog.this.setTitle(I18n.tr((String)"{0}.Wikipedia.org: coordinates", (Object[])new Object[]{WikipediaToggleDialog.this.wikipediaLang.get()}));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

